/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.page.mem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import parquet.Log;
import parquet.column.ColumnDescriptor;
import parquet.column.UnknownColumnException;
import parquet.column.page.Page;
import parquet.column.page.PageReadStore;
import parquet.column.page.PageReader;
import parquet.column.page.PageWriteStore;
import parquet.column.page.PageWriter;
import parquet.column.page.mem.MemPageReader;
import parquet.column.page.mem.MemPageWriter;

public class MemPageStore
implements PageReadStore,
PageWriteStore {
    private static final Log LOG = Log.getLog(MemPageStore.class);
    private Map<ColumnDescriptor, MemPageWriter> pageWriters = new HashMap<ColumnDescriptor, MemPageWriter>();
    private long rowCount;

    public MemPageStore(long rowCount) {
        this.rowCount = rowCount;
    }

    public PageWriter getPageWriter(ColumnDescriptor path) {
        MemPageWriter pageWriter = this.pageWriters.get(path);
        if (pageWriter == null) {
            pageWriter = new MemPageWriter();
            this.pageWriters.put(path, pageWriter);
        }
        return pageWriter;
    }

    public PageReader getPageReader(ColumnDescriptor descriptor) {
        MemPageWriter pageWriter = this.pageWriters.get(descriptor);
        if (pageWriter == null) {
            throw new UnknownColumnException(descriptor);
        }
        ArrayList<Page> pages = new ArrayList<Page>(pageWriter.getPages());
        if (Log.DEBUG) {
            LOG.debug((Object)("initialize page reader with " + pageWriter.getTotalValueCount() + " values and " + pages.size() + " pages"));
        }
        return new MemPageReader(pageWriter.getTotalValueCount(), pages.iterator(), pageWriter.getDictionaryPage());
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public void addRowCount(long count) {
        this.rowCount += count;
    }
}

