/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.values.dictionary;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import parquet.bytes.BytesInput;
import parquet.column.ColumnDescriptor;
import parquet.column.Dictionary;
import parquet.column.Encoding;
import parquet.column.page.DictionaryPage;
import parquet.column.values.ValuesReader;
import parquet.column.values.ValuesWriter;
import parquet.column.values.dictionary.DictionaryValuesReader;
import parquet.column.values.dictionary.DictionaryValuesWriter;
import parquet.column.values.plain.BinaryPlainValuesReader;
import parquet.column.values.plain.PlainValuesReader;
import parquet.io.api.Binary;
import parquet.schema.PrimitiveType;

public class TestDictionary {
    @Test
    public void testBinaryDictionary() throws IOException {
        int COUNT = 100;
        DictionaryValuesWriter.PlainBinaryDictionaryValuesWriter cw = new DictionaryValuesWriter.PlainBinaryDictionaryValuesWriter(200, 10000);
        this.writeRepeated(COUNT, (ValuesWriter)cw, "a");
        BytesInput bytes1 = this.getBytesAndCheckEncoding((ValuesWriter)cw, Encoding.PLAIN_DICTIONARY);
        this.writeRepeated(COUNT, (ValuesWriter)cw, "b");
        BytesInput bytes2 = this.getBytesAndCheckEncoding((ValuesWriter)cw, Encoding.PLAIN_DICTIONARY);
        this.writeDistinct(COUNT, (ValuesWriter)cw, "c");
        BytesInput bytes3 = this.getBytesAndCheckEncoding((ValuesWriter)cw, Encoding.PLAIN);
        DictionaryValuesReader cr = this.initDicReader((ValuesWriter)cw, PrimitiveType.PrimitiveTypeName.BINARY);
        this.checkRepeated(COUNT, bytes1, (ValuesReader)cr, "a");
        this.checkRepeated(COUNT, bytes2, (ValuesReader)cr, "b");
        BinaryPlainValuesReader cr2 = new BinaryPlainValuesReader();
        this.checkDistinct(COUNT, bytes3, (ValuesReader)cr2, "c");
    }

    @Test
    public void testBinaryDictionaryFallBack() throws IOException {
        int slabSize = 100;
        int maxDictionaryByteSize = 50;
        DictionaryValuesWriter.PlainBinaryDictionaryValuesWriter cw = new DictionaryValuesWriter.PlainBinaryDictionaryValuesWriter(maxDictionaryByteSize, slabSize);
        int fallBackThreshold = maxDictionaryByteSize;
        int dataSize = 0;
        for (long i = 0L; i < 100L; ++i) {
            Binary binary = Binary.fromString((String)("str" + i));
            cw.writeBytes(binary);
            if ((dataSize += binary.length() + 4) < fallBackThreshold) {
                Assert.assertEquals((Object)Encoding.PLAIN_DICTIONARY, (Object)cw.getEncoding());
                continue;
            }
            Assert.assertEquals((Object)Encoding.PLAIN, (Object)cw.getEncoding());
        }
        BinaryPlainValuesReader reader = new BinaryPlainValuesReader();
        reader.initFromPage(100L, cw.getBytes().toByteArray(), 0);
        for (long i = 0L; i < 100L; ++i) {
            Assert.assertEquals((Object)Binary.fromString((String)("str" + i)), (Object)reader.readBytes());
        }
    }

    @Test
    public void testFirstPageFallBack() throws IOException {
        int COUNT = 1000;
        DictionaryValuesWriter.PlainBinaryDictionaryValuesWriter cw = new DictionaryValuesWriter.PlainBinaryDictionaryValuesWriter(10000, 10000);
        this.writeDistinct(COUNT, (ValuesWriter)cw, "a");
        BytesInput bytes1 = this.getBytesAndCheckEncoding((ValuesWriter)cw, Encoding.PLAIN);
        this.writeRepeated(COUNT, (ValuesWriter)cw, "b");
        BytesInput bytes2 = this.getBytesAndCheckEncoding((ValuesWriter)cw, Encoding.PLAIN);
        BinaryPlainValuesReader cr = new BinaryPlainValuesReader();
        this.checkDistinct(COUNT, bytes1, (ValuesReader)cr, "a");
        this.checkRepeated(COUNT, bytes2, (ValuesReader)cr, "b");
    }

    @Test
    public void testSecondPageFallBack() throws IOException {
        int COUNT = 1000;
        DictionaryValuesWriter.PlainBinaryDictionaryValuesWriter cw = new DictionaryValuesWriter.PlainBinaryDictionaryValuesWriter(1000, 10000);
        this.writeRepeated(COUNT, (ValuesWriter)cw, "a");
        BytesInput bytes1 = this.getBytesAndCheckEncoding((ValuesWriter)cw, Encoding.PLAIN_DICTIONARY);
        this.writeDistinct(COUNT, (ValuesWriter)cw, "b");
        BytesInput bytes2 = this.getBytesAndCheckEncoding((ValuesWriter)cw, Encoding.PLAIN);
        this.writeRepeated(COUNT, (ValuesWriter)cw, "a");
        BytesInput bytes3 = this.getBytesAndCheckEncoding((ValuesWriter)cw, Encoding.PLAIN);
        DictionaryValuesReader cr = this.initDicReader((ValuesWriter)cw, PrimitiveType.PrimitiveTypeName.BINARY);
        this.checkRepeated(COUNT, bytes1, (ValuesReader)cr, "a");
        cr = new BinaryPlainValuesReader();
        this.checkDistinct(COUNT, bytes2, (ValuesReader)cr, "b");
        this.checkRepeated(COUNT, bytes3, (ValuesReader)cr, "a");
    }

    @Test
    public void testLongDictionary() throws IOException {
        long back;
        long i;
        int COUNT = 1000;
        int COUNT2 = 2000;
        DictionaryValuesWriter.PlainLongDictionaryValuesWriter cw = new DictionaryValuesWriter.PlainLongDictionaryValuesWriter(10000, 10000);
        for (long i2 = 0L; i2 < (long)COUNT; ++i2) {
            cw.writeLong(i2 % 50L);
        }
        BytesInput bytes1 = this.getBytesAndCheckEncoding((ValuesWriter)cw, Encoding.PLAIN_DICTIONARY);
        Assert.assertEquals((long)50L, (long)cw.getDictionarySize());
        for (long i3 = (long)COUNT2; i3 > 0L; --i3) {
            cw.writeLong(i3 % 50L);
        }
        BytesInput bytes2 = this.getBytesAndCheckEncoding((ValuesWriter)cw, Encoding.PLAIN_DICTIONARY);
        Assert.assertEquals((long)50L, (long)cw.getDictionarySize());
        DictionaryValuesReader cr = this.initDicReader((ValuesWriter)cw, PrimitiveType.PrimitiveTypeName.INT64);
        cr.initFromPage((long)COUNT, bytes1.toByteArray(), 0);
        for (i = 0L; i < (long)COUNT; ++i) {
            back = cr.readLong();
            Assert.assertEquals((long)(i % 50L), (long)back);
        }
        cr.initFromPage((long)COUNT2, bytes2.toByteArray(), 0);
        for (i = (long)COUNT2; i > 0L; --i) {
            back = cr.readLong();
            Assert.assertEquals((long)(i % 50L), (long)back);
        }
    }

    @Test
    public void testLongDictionaryFallBack() throws IOException {
        int slabSize = 100;
        int maxDictionaryByteSize = 50;
        DictionaryValuesWriter.PlainLongDictionaryValuesWriter cw = new DictionaryValuesWriter.PlainLongDictionaryValuesWriter(maxDictionaryByteSize, slabSize);
        int fallBackThreshold = maxDictionaryByteSize / 8;
        for (long i = 0L; i < 100L; ++i) {
            cw.writeLong(i);
            if (i < (long)fallBackThreshold) {
                Assert.assertEquals((Object)cw.getEncoding(), (Object)Encoding.PLAIN_DICTIONARY);
                continue;
            }
            Assert.assertEquals((Object)cw.getEncoding(), (Object)Encoding.PLAIN);
        }
        PlainValuesReader.LongPlainValuesReader reader = new PlainValuesReader.LongPlainValuesReader();
        reader.initFromPage(100L, cw.getBytes().toByteArray(), 0);
        for (long i = 0L; i < 100L; ++i) {
            Assert.assertEquals((long)i, (long)reader.readLong());
        }
    }

    @Test
    public void testDoubleDictionary() throws IOException {
        double back;
        double i;
        int COUNT = 1000;
        int COUNT2 = 2000;
        DictionaryValuesWriter.PlainDoubleDictionaryValuesWriter cw = new DictionaryValuesWriter.PlainDoubleDictionaryValuesWriter(10000, 10000);
        for (double i2 = 0.0; i2 < (double)COUNT; i2 += 1.0) {
            cw.writeDouble(i2 % 50.0);
        }
        BytesInput bytes1 = this.getBytesAndCheckEncoding((ValuesWriter)cw, Encoding.PLAIN_DICTIONARY);
        Assert.assertEquals((long)50L, (long)cw.getDictionarySize());
        for (double i3 = (double)COUNT2; i3 > 0.0; i3 -= 1.0) {
            cw.writeDouble(i3 % 50.0);
        }
        BytesInput bytes2 = this.getBytesAndCheckEncoding((ValuesWriter)cw, Encoding.PLAIN_DICTIONARY);
        Assert.assertEquals((long)50L, (long)cw.getDictionarySize());
        DictionaryValuesReader cr = this.initDicReader((ValuesWriter)cw, PrimitiveType.PrimitiveTypeName.DOUBLE);
        cr.initFromPage((long)COUNT, bytes1.toByteArray(), 0);
        for (i = 0.0; i < (double)COUNT; i += 1.0) {
            back = cr.readDouble();
            Assert.assertEquals((double)(i % 50.0), (double)back, (double)0.0);
        }
        cr.initFromPage((long)COUNT2, bytes2.toByteArray(), 0);
        for (i = (double)COUNT2; i > 0.0; i -= 1.0) {
            back = cr.readDouble();
            Assert.assertEquals((double)(i % 50.0), (double)back, (double)0.0);
        }
    }

    @Test
    public void testDoubleDictionaryFallBack() throws IOException {
        int slabSize = 100;
        int maxDictionaryByteSize = 50;
        DictionaryValuesWriter.PlainDoubleDictionaryValuesWriter cw = new DictionaryValuesWriter.PlainDoubleDictionaryValuesWriter(maxDictionaryByteSize, slabSize);
        int fallBackThreshold = maxDictionaryByteSize / 8;
        for (double i = 0.0; i < 100.0; i += 1.0) {
            cw.writeDouble(i);
            if (i < (double)fallBackThreshold) {
                Assert.assertEquals((Object)cw.getEncoding(), (Object)Encoding.PLAIN_DICTIONARY);
                continue;
            }
            Assert.assertEquals((Object)cw.getEncoding(), (Object)Encoding.PLAIN);
        }
        PlainValuesReader.DoublePlainValuesReader reader = new PlainValuesReader.DoublePlainValuesReader();
        reader.initFromPage(100L, cw.getBytes().toByteArray(), 0);
        for (float i = 0.0f; i < 100.0f; i += 1.0f) {
            Assert.assertEquals((double)i, (double)reader.readDouble(), (double)1.0E-5);
        }
    }

    @Test
    public void testIntDictionary() throws IOException {
        int back;
        int i;
        int COUNT = 2000;
        int COUNT2 = 4000;
        DictionaryValuesWriter.PlainIntegerDictionaryValuesWriter cw = new DictionaryValuesWriter.PlainIntegerDictionaryValuesWriter(10000, 10000);
        for (int i2 = 0; i2 < COUNT; ++i2) {
            cw.writeInteger(i2 % 50);
        }
        BytesInput bytes1 = this.getBytesAndCheckEncoding((ValuesWriter)cw, Encoding.PLAIN_DICTIONARY);
        Assert.assertEquals((long)50L, (long)cw.getDictionarySize());
        for (int i3 = COUNT2; i3 > 0; --i3) {
            cw.writeInteger(i3 % 50);
        }
        BytesInput bytes2 = this.getBytesAndCheckEncoding((ValuesWriter)cw, Encoding.PLAIN_DICTIONARY);
        Assert.assertEquals((long)50L, (long)cw.getDictionarySize());
        DictionaryValuesReader cr = this.initDicReader((ValuesWriter)cw, PrimitiveType.PrimitiveTypeName.INT32);
        cr.initFromPage((long)COUNT, bytes1.toByteArray(), 0);
        for (i = 0; i < COUNT; ++i) {
            back = cr.readInteger();
            Assert.assertEquals((long)(i % 50), (long)back);
        }
        cr.initFromPage((long)COUNT2, bytes2.toByteArray(), 0);
        for (i = COUNT2; i > 0; --i) {
            back = cr.readInteger();
            Assert.assertEquals((long)(i % 50), (long)back);
        }
    }

    @Test
    public void testIntDictionaryFallBack() throws IOException {
        int slabSize = 100;
        int maxDictionaryByteSize = 50;
        DictionaryValuesWriter.PlainIntegerDictionaryValuesWriter cw = new DictionaryValuesWriter.PlainIntegerDictionaryValuesWriter(maxDictionaryByteSize, slabSize);
        int fallBackThreshold = maxDictionaryByteSize / 4;
        for (int i = 0; i < 100; ++i) {
            cw.writeInteger(i);
            if (i < fallBackThreshold) {
                Assert.assertEquals((Object)cw.getEncoding(), (Object)Encoding.PLAIN_DICTIONARY);
                continue;
            }
            Assert.assertEquals((Object)cw.getEncoding(), (Object)Encoding.PLAIN);
        }
        PlainValuesReader.IntegerPlainValuesReader reader = new PlainValuesReader.IntegerPlainValuesReader();
        reader.initFromPage(100L, cw.getBytes().toByteArray(), 0);
        for (int i = 0; i < 100; ++i) {
            Assert.assertEquals((long)i, (long)reader.readInteger());
        }
    }

    @Test
    public void testFloatDictionary() throws IOException {
        float back;
        float i;
        int COUNT = 2000;
        int COUNT2 = 4000;
        DictionaryValuesWriter.PlainFloatDictionaryValuesWriter cw = new DictionaryValuesWriter.PlainFloatDictionaryValuesWriter(10000, 10000);
        for (float i2 = 0.0f; i2 < (float)COUNT; i2 += 1.0f) {
            cw.writeFloat(i2 % 50.0f);
        }
        BytesInput bytes1 = this.getBytesAndCheckEncoding((ValuesWriter)cw, Encoding.PLAIN_DICTIONARY);
        Assert.assertEquals((long)50L, (long)cw.getDictionarySize());
        for (float i3 = (float)COUNT2; i3 > 0.0f; i3 -= 1.0f) {
            cw.writeFloat(i3 % 50.0f);
        }
        BytesInput bytes2 = this.getBytesAndCheckEncoding((ValuesWriter)cw, Encoding.PLAIN_DICTIONARY);
        Assert.assertEquals((long)50L, (long)cw.getDictionarySize());
        DictionaryValuesReader cr = this.initDicReader((ValuesWriter)cw, PrimitiveType.PrimitiveTypeName.FLOAT);
        cr.initFromPage((long)COUNT, bytes1.toByteArray(), 0);
        for (i = 0.0f; i < (float)COUNT; i += 1.0f) {
            back = cr.readFloat();
            Assert.assertEquals((double)(i % 50.0f), (double)back, (double)0.0);
        }
        cr.initFromPage((long)COUNT2, bytes2.toByteArray(), 0);
        for (i = (float)COUNT2; i > 0.0f; i -= 1.0f) {
            back = cr.readFloat();
            Assert.assertEquals((double)(i % 50.0f), (double)back, (double)0.0);
        }
    }

    @Test
    public void testFloatDictionaryFallBack() throws IOException {
        int slabSize = 100;
        int maxDictionaryByteSize = 50;
        DictionaryValuesWriter.PlainFloatDictionaryValuesWriter cw = new DictionaryValuesWriter.PlainFloatDictionaryValuesWriter(maxDictionaryByteSize, slabSize);
        int fallBackThreshold = maxDictionaryByteSize / 4;
        for (float i = 0.0f; i < 100.0f; i += 1.0f) {
            cw.writeFloat(i);
            if (i < (float)fallBackThreshold) {
                Assert.assertEquals((Object)cw.getEncoding(), (Object)Encoding.PLAIN_DICTIONARY);
                continue;
            }
            Assert.assertEquals((Object)cw.getEncoding(), (Object)Encoding.PLAIN);
        }
        PlainValuesReader.FloatPlainValuesReader reader = new PlainValuesReader.FloatPlainValuesReader();
        reader.initFromPage(100L, cw.getBytes().toByteArray(), 0);
        for (float i = 0.0f; i < 100.0f; i += 1.0f) {
            Assert.assertEquals((double)i, (double)reader.readFloat(), (double)1.0E-5);
        }
    }

    private DictionaryValuesReader initDicReader(ValuesWriter cw, PrimitiveType.PrimitiveTypeName type) throws IOException {
        DictionaryPage dictionaryPage = cw.createDictionaryPage().copy();
        ColumnDescriptor descriptor = new ColumnDescriptor(new String[]{"foo"}, type, 0, 0);
        Dictionary dictionary = Encoding.PLAIN_DICTIONARY.initDictionary(descriptor, dictionaryPage);
        DictionaryValuesReader cr = new DictionaryValuesReader(dictionary);
        return cr;
    }

    private void checkDistinct(int COUNT, BytesInput bytes, ValuesReader cr, String prefix) throws IOException {
        cr.initFromPage((long)COUNT, bytes.toByteArray(), 0);
        for (int i = 0; i < COUNT; ++i) {
            Assert.assertEquals((Object)(prefix + i), (Object)cr.readBytes().toStringUsingUTF8());
        }
    }

    private void checkRepeated(int COUNT, BytesInput bytes, ValuesReader cr, String prefix) throws IOException {
        cr.initFromPage((long)COUNT, bytes.toByteArray(), 0);
        for (int i = 0; i < COUNT; ++i) {
            Assert.assertEquals((Object)(prefix + i % 10), (Object)cr.readBytes().toStringUsingUTF8());
        }
    }

    private void writeDistinct(int COUNT, ValuesWriter cw, String prefix) {
        for (int i = 0; i < COUNT; ++i) {
            cw.writeBytes(Binary.fromString((String)(prefix + i)));
        }
    }

    private void writeRepeated(int COUNT, ValuesWriter cw, String prefix) {
        for (int i = 0; i < COUNT; ++i) {
            cw.writeBytes(Binary.fromString((String)(prefix + i % 10)));
        }
    }

    private BytesInput getBytesAndCheckEncoding(ValuesWriter cw, Encoding encoding) throws IOException {
        BytesInput bytes = BytesInput.copy((BytesInput)cw.getBytes());
        Assert.assertEquals((Object)encoding, (Object)cw.getEncoding());
        cw.reset();
        return bytes;
    }
}

