/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.scalding.parquet.tuple;

import cascading.tuple.Tuple;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.Type;

public class ParquetTupleConverter
extends GroupConverter {
    protected Tuple currentTuple;
    private final Converter[] converters;

    public ParquetTupleConverter(GroupType groupType) {
        int n = groupType.getFieldCount();
        this.converters = new Converter[n];
        for (int i = 0; i < n; ++i) {
            Type type = groupType.getType(i);
            this.converters[i] = this.newConverter(type, i);
        }
    }

    private Converter newConverter(Type type, int n) {
        if (!type.isPrimitive()) {
            throw new IllegalArgumentException("cascading can only build tuples from primitive types");
        }
        return new TuplePrimitiveConverter(this, n);
    }

    public Converter getConverter(int n) {
        return this.converters[n];
    }

    public final void start() {
        this.currentTuple = Tuple.size((int)this.converters.length);
    }

    public void end() {
    }

    public final Tuple getCurrentTuple() {
        return this.currentTuple;
    }

    static final class TuplePrimitiveConverter
    extends PrimitiveConverter {
        private final ParquetTupleConverter parent;
        private final int index;

        public TuplePrimitiveConverter(ParquetTupleConverter parquetTupleConverter, int n) {
            this.parent = parquetTupleConverter;
            this.index = n;
        }

        public void addBinary(Binary binary) {
            this.parent.getCurrentTuple().setString(this.index, binary.toStringUsingUTF8());
        }

        public void addBoolean(boolean bl) {
            this.parent.getCurrentTuple().setBoolean(this.index, bl);
        }

        public void addDouble(double d) {
            this.parent.getCurrentTuple().setDouble(this.index, d);
        }

        public void addFloat(float f) {
            this.parent.getCurrentTuple().setFloat(this.index, f);
        }

        public void addInt(int n) {
            this.parent.getCurrentTuple().setInteger(this.index, n);
        }

        public void addLong(long l) {
            this.parent.getCurrentTuple().setLong(this.index, l);
        }
    }
}

