/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.scalding.parquet.tuple;

import cascading.flow.FlowProcess;
import cascading.scheme.Scheme;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.tap.CompositeTap;
import cascading.tap.Tap;
import cascading.tap.TapException;
import cascading.tap.hadoop.Hfs;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import com.twitter.scalding.parquet.tuple.SchemaIntersection;
import com.twitter.scalding.parquet.tuple.TupleReadSupport;
import com.twitter.scalding.parquet.tuple.TupleWriteSupport;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.parquet.Preconditions;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.mapred.Container;
import org.apache.parquet.hadoop.mapred.DeprecatedParquetInputFormat;
import org.apache.parquet.hadoop.mapred.DeprecatedParquetOutputFormat;
import org.apache.parquet.schema.MessageType;

public class ParquetTupleScheme
extends Scheme<JobConf, RecordReader, OutputCollector, Object[], Object[]> {
    private static final long serialVersionUID = 0L;
    private String parquetSchema;
    private final FilterPredicate filterPredicate;

    public ParquetTupleScheme() {
        this.filterPredicate = null;
    }

    public ParquetTupleScheme(Fields fields) {
        super(fields);
        this.filterPredicate = null;
    }

    public ParquetTupleScheme(FilterPredicate filterPredicate) {
        this.filterPredicate = (FilterPredicate)Preconditions.checkNotNull((Object)filterPredicate, (String)"filterPredicate");
    }

    public ParquetTupleScheme(FilterPredicate filterPredicate, Fields fields) {
        super(fields);
        this.filterPredicate = (FilterPredicate)Preconditions.checkNotNull((Object)filterPredicate, (String)"filterPredicate");
    }

    public ParquetTupleScheme(Fields fields, Fields fields2, String string) {
        super(fields, fields2);
        this.parquetSchema = string;
        this.filterPredicate = null;
    }

    public void sourceConfInit(FlowProcess<JobConf> flowProcess, Tap<JobConf, RecordReader, OutputCollector> tap, JobConf jobConf) {
        if (this.filterPredicate != null) {
            ParquetInputFormat.setFilterPredicate((Configuration)jobConf, (FilterPredicate)this.filterPredicate);
        }
        jobConf.setInputFormat(DeprecatedParquetInputFormat.class);
        ParquetInputFormat.setReadSupportClass((JobConf)jobConf, TupleReadSupport.class);
        TupleReadSupport.setRequestedFields(jobConf, this.getSourceFields());
    }

    public Fields retrieveSourceFields(FlowProcess<JobConf> flowProcess, Tap tap) {
        MessageType messageType = this.readSchema(flowProcess, tap);
        SchemaIntersection schemaIntersection = new SchemaIntersection(messageType, this.getSourceFields());
        this.setSourceFields(schemaIntersection.getSourceFields());
        return this.getSourceFields();
    }

    private MessageType readSchema(FlowProcess<JobConf> flowProcess, Tap tap) {
        try {
            Hfs hfs = tap instanceof CompositeTap ? (Hfs)((CompositeTap)tap).getChildTaps().next() : (Hfs)tap;
            List<Footer> list = this.getFooters(flowProcess, hfs);
            if (list.isEmpty()) {
                throw new TapException("Could not read Parquet metadata at " + hfs.getPath());
            }
            return list.get(0).getParquetMetadata().getFileMetaData().getSchema();
        }
        catch (IOException iOException) {
            throw new TapException((Throwable)iOException);
        }
    }

    private List<Footer> getFooters(FlowProcess<JobConf> flowProcess, Hfs hfs) throws IOException {
        JobConf jobConf = (JobConf)flowProcess.getConfigCopy();
        DeprecatedParquetInputFormat deprecatedParquetInputFormat = new DeprecatedParquetInputFormat();
        DeprecatedParquetInputFormat.addInputPath((JobConf)jobConf, (Path)hfs.getPath());
        return deprecatedParquetInputFormat.getFooters(jobConf);
    }

    public boolean source(FlowProcess<JobConf> flowProcess, SourceCall<Object[], RecordReader> sourceCall) throws IOException {
        Container container = (Container)((RecordReader)sourceCall.getInput()).createValue();
        boolean bl = ((RecordReader)sourceCall.getInput()).next(null, (Object)container);
        if (!bl) {
            return false;
        }
        if (container == null) {
            return true;
        }
        sourceCall.getIncomingEntry().setTuple((Tuple)container.get());
        return true;
    }

    public void sinkConfInit(FlowProcess<JobConf> flowProcess, Tap<JobConf, RecordReader, OutputCollector> tap, JobConf jobConf) {
        DeprecatedParquetOutputFormat.setAsOutputFormat((JobConf)jobConf);
        jobConf.set("parquet.cascading.schema", this.parquetSchema);
        ParquetOutputFormat.setWriteSupportClass((JobConf)jobConf, TupleWriteSupport.class);
    }

    public boolean isSink() {
        return this.parquetSchema != null;
    }

    public void sink(FlowProcess<JobConf> flowProcess, SinkCall<Object[], OutputCollector> sinkCall) throws IOException {
        TupleEntry tupleEntry = sinkCall.getOutgoingEntry();
        OutputCollector outputCollector = (OutputCollector)sinkCall.getOutput();
        outputCollector.collect(null, (Object)tupleEntry);
    }
}

