/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.scalding.parquet.tuple;

import cascading.tuple.TupleEntry;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public class TupleWriteSupport
extends WriteSupport<TupleEntry> {
    private RecordConsumer recordConsumer;
    private MessageType rootSchema;
    public static final String PARQUET_CASCADING_SCHEMA = "parquet.cascading.schema";

    public String getName() {
        return "cascading";
    }

    public WriteSupport.WriteContext init(Configuration configuration) {
        String string = configuration.get(PARQUET_CASCADING_SCHEMA);
        this.rootSchema = MessageTypeParser.parseMessageType((String)string);
        return new WriteSupport.WriteContext(this.rootSchema, new HashMap());
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.recordConsumer = recordConsumer;
    }

    public void write(TupleEntry tupleEntry) {
        this.recordConsumer.startMessage();
        List list = this.rootSchema.getFields();
        for (int i = 0; i < list.size(); ++i) {
            Type type = (Type)list.get(i);
            if (tupleEntry == null || tupleEntry.getObject((Comparable)((Object)type.getName())) == null) continue;
            this.recordConsumer.startField(type.getName(), i);
            if (!type.isPrimitive()) {
                throw new UnsupportedOperationException("Complex type not implemented");
            }
            this.writePrimitive(tupleEntry, type.asPrimitiveType());
            this.recordConsumer.endField(type.getName(), i);
        }
        this.recordConsumer.endMessage();
    }

    private void writePrimitive(TupleEntry tupleEntry, PrimitiveType primitiveType) {
        switch (primitiveType.getPrimitiveTypeName()) {
            case BINARY: {
                this.recordConsumer.addBinary(Binary.fromString((String)tupleEntry.getString((Comparable)((Object)primitiveType.getName()))));
                break;
            }
            case BOOLEAN: {
                this.recordConsumer.addBoolean(tupleEntry.getBoolean((Comparable)((Object)primitiveType.getName())));
                break;
            }
            case INT32: {
                this.recordConsumer.addInteger(tupleEntry.getInteger((Comparable)((Object)primitiveType.getName())));
                break;
            }
            case INT64: {
                this.recordConsumer.addLong(tupleEntry.getLong((Comparable)((Object)primitiveType.getName())));
                break;
            }
            case DOUBLE: {
                this.recordConsumer.addDouble(tupleEntry.getDouble((Comparable)((Object)primitiveType.getName())));
                break;
            }
            case FLOAT: {
                this.recordConsumer.addFloat(tupleEntry.getFloat((Comparable)((Object)primitiveType.getName())));
                break;
            }
            case FIXED_LEN_BYTE_ARRAY: {
                throw new UnsupportedOperationException("Fixed len byte array type not implemented");
            }
            case INT96: {
                throw new UnsupportedOperationException("Int96 type not implemented");
            }
            default: {
                throw new UnsupportedOperationException(primitiveType.getName() + " type not implemented");
            }
        }
    }
}

