/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.server.handler;

import com.twitter.finagle.Service;
import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.Response;
import com.twitter.finagle.http.Status;
import com.twitter.finagle.http.Version;
import com.twitter.io.Buf;
import com.twitter.server.handler.ThreadsHandler$;
import com.twitter.server.util.HttpUtils$;
import com.twitter.server.util.JsonConverter$;
import com.twitter.server.view.ThreadsView;
import com.twitter.util.Future;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\t=qAB\u0001\u0003\u0011\u0003!!\"\u0001\bUQJ,\u0017\rZ:IC:$G.\u001a:\u000b\u0005\r!\u0011a\u00025b]\u0012dWM\u001d\u0006\u0003\u000b\u0019\taa]3sm\u0016\u0014(BA\u0004\t\u0003\u001d!x/\u001b;uKJT\u0011!C\u0001\u0004G>l\u0007CA\u0006\r\u001b\u0005\u0011aAB\u0007\u0003\u0011\u0003!aB\u0001\bUQJ,\u0017\rZ:IC:$G.\u001a:\u0014\u00051y\u0001C\u0001\t\u0014\u001b\u0005\t\"\"\u0001\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\t\"AB!osJ+g\rC\u0003\u0017\u0019\u0011\u0005\u0001$\u0001\u0004=S:LGOP\u0002\u0001)\u0005QQ\u0001\u0002\u000e\r\u0001m\u0011!b\u0015;bG.$&/Y2f!\raBe\n\b\u0003;\tr!AH\u0011\u000e\u0003}Q!\u0001I\f\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0012BA\u0012\u0012\u0003\u001d\u0001\u0018mY6bO\u0016L!!\n\u0014\u0003\u0007M+\u0017O\u0003\u0002$#A\u0011\u0001&L\u0007\u0002S)\u0011!fK\u0001\u0005Y\u0006twMC\u0001-\u0003\u0011Q\u0017M^1\n\u00059J#!E*uC\u000e\\GK]1dK\u0016cW-\\3oi\u001a!\u0001\u0007\u0004!2\u0005)!\u0006N]3bI&sgm\\\n\u0005_=\u0011T\u0007\u0005\u0002\u0011g%\u0011A'\u0005\u0002\b!J|G-^2u!\t\u0001b'\u0003\u00028#\ta1+\u001a:jC2L'0\u00192mK\"A\u0011h\fBK\u0002\u0013\u0005!(\u0001\u0004uQJ,\u0017\rZ\u000b\u0002wA\u0011\u0001\u0006P\u0005\u0003{%\u0012a\u0001\u00165sK\u0006$\u0007\u0002C 0\u0005#\u0005\u000b\u0011B\u001e\u0002\u000fQD'/Z1eA!A\u0011i\fBK\u0002\u0013\u0005!)A\u0003ti\u0006\u001c7.F\u0001D!\t!\u0015$D\u0001\r\u0011!1uF!E!\u0002\u0013\u0019\u0015AB:uC\u000e\\\u0007\u0005\u0003\u0005I_\tU\r\u0011\"\u0001J\u0003\u0019I7/\u00133mKV\t!\n\u0005\u0002\u0011\u0017&\u0011A*\u0005\u0002\b\u0005>|G.Z1o\u0011!quF!E!\u0002\u0013Q\u0015aB5t\u0013\u0012dW\r\t\u0005\u0006-=\"\t\u0001\u0015\u000b\u0005#J\u001bF\u000b\u0005\u0002E_!)\u0011h\u0014a\u0001w!)\u0011i\u0014a\u0001\u0007\")\u0001j\u0014a\u0001\u0015\"9akLA\u0001\n\u00039\u0016\u0001B2paf$B!\u0015-Z5\"9\u0011(\u0016I\u0001\u0002\u0004Y\u0004bB!V!\u0003\u0005\ra\u0011\u0005\b\u0011V\u0003\n\u00111\u0001K\u0011\u001dav&%A\u0005\u0002u\u000babY8qs\u0012\"WMZ1vYR$\u0013'F\u0001_U\tYtlK\u0001a!\t\tg-D\u0001c\u0015\t\u0019G-A\u0005v]\u000eDWmY6fI*\u0011Q-E\u0001\u000bC:tw\u000e^1uS>t\u0017BA4c\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\bS>\n\n\u0011\"\u0001k\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\u0012a\u001b\u0016\u0003\u0007~Cq!\\\u0018\u0012\u0002\u0013\u0005a.\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0003=T#AS0\t\u000fE|\u0013\u0011!C!e\u0006i\u0001O]8ek\u000e$\bK]3gSb,\u0012a\u001d\t\u0003QQL!!^\u0015\u0003\rM#(/\u001b8h\u0011\u001d9x&!A\u0005\u0002a\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\u0012!\u001f\t\u0003!iL!a_\t\u0003\u0007%sG\u000fC\u0004~_\u0005\u0005I\u0011\u0001@\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019q0!\u0002\u0011\u0007A\t\t!C\u0002\u0002\u0004E\u00111!\u00118z\u0011!\t9\u0001`A\u0001\u0002\u0004I\u0018a\u0001=%c!I\u00111B\u0018\u0002\u0002\u0013\u0005\u0013QB\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u0002\t\u0006\u0003#\t9b`\u0007\u0003\u0003'Q1!!\u0006\u0012\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u00033\t\u0019B\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\tibLA\u0001\n\u0003\ty\"\u0001\u0005dC:,\u0015/^1m)\rQ\u0015\u0011\u0005\u0005\n\u0003\u000f\tY\"!AA\u0002}D\u0011\"!\n0\u0003\u0003%\t%a\n\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012!\u001f\u0005\n\u0003Wy\u0013\u0011!C!\u0003[\t\u0001\u0002^8TiJLgn\u001a\u000b\u0002g\"I\u0011\u0011G\u0018\u0002\u0002\u0013\u0005\u00131G\u0001\u0007KF,\u0018\r\\:\u0015\u0007)\u000b)\u0004C\u0005\u0002\b\u0005=\u0012\u0011!a\u0001\u007f\u001eI\u0011\u0011\b\u0007\u0002\u0002#\u0005\u00111H\u0001\u000b)\"\u0014X-\u00193J]\u001a|\u0007c\u0001#\u0002>\u0019A\u0001\u0007DA\u0001\u0012\u0003\tydE\u0003\u0002>\u0005\u0005S\u0007\u0005\u0005\u0002D\u0005%3h\u0011&R\u001b\t\t)EC\u0002\u0002HE\tqA];oi&lW-\u0003\u0003\u0002L\u0005\u0015#!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8og!9a#!\u0010\u0005\u0002\u0005=CCAA\u001e\u0011)\tY#!\u0010\u0002\u0002\u0013\u0015\u0013Q\u0006\u0005\u000b\u0003+\ni$!A\u0005\u0002\u0006]\u0013!B1qa2LHcB)\u0002Z\u0005m\u0013Q\f\u0005\u0007s\u0005M\u0003\u0019A\u001e\t\r\u0005\u000b\u0019\u00061\u0001D\u0011\u0019A\u00151\u000ba\u0001\u0015\"Q\u0011\u0011MA\u001f\u0003\u0003%\t)a\u0019\u0002\u000fUt\u0017\r\u001d9msR!\u0011QMA9!\u0015\u0001\u0012qMA6\u0013\r\tI'\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\rA\tigO\"K\u0013\r\ty'\u0005\u0002\u0007)V\u0004H.Z\u001a\t\u0013\u0005M\u0014qLA\u0001\u0002\u0004\t\u0016a\u0001=%a!Q\u0011qOA\u001f\u0003\u0003%I!!\u001f\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003w\u00022\u0001KA?\u0013\r\ty(\u000b\u0002\u0007\u001f\nTWm\u0019;\t\u0013\u0005\rEB1A\u0005\n\u0005\u0015\u0015AE%eY\u0016\u001cE.Y:t\u0003:$W*\u001a;i_\u0012,\"!a\"\u0011\r\u0005%\u0015\u0011SAL\u001d\u0011\tY)!$\u0011\u0005y\t\u0012bAAH#\u00051\u0001K]3eK\u001aLA!a%\u0002\u0016\n\u00191+\u001a;\u000b\u0007\u0005=\u0015\u0003E\u0004\u0011\u00033\u000bi*!(\n\u0007\u0005m\u0015C\u0001\u0004UkBdWM\r\t\u0005\u0003\u0013\u000by*C\u0002v\u0003+C\u0001\"a)\rA\u0003%\u0011qQ\u0001\u0014\u0013\u0012dWm\u00117bgN\fe\u000eZ'fi\"|G\r\t\u0004\u0006\u001b\t\u0001\u0011qU\n\u0005\u0003K\u000bI\u000b\u0005\u0005\u0002,\u0006E\u0016QWAa\u001b\t\tiKC\u0002\u00020\u001a\tqAZ5oC\u001edW-\u0003\u0003\u00024\u00065&aB*feZL7-\u001a\t\u0005\u0003o\u000bi,\u0004\u0002\u0002:*!\u00111XAW\u0003\u0011AG\u000f\u001e9\n\t\u0005}\u0016\u0011\u0018\u0002\b%\u0016\fX/Z:u!\u0011\t9,a1\n\t\u0005\u0015\u0017\u0011\u0018\u0002\t%\u0016\u001c\bo\u001c8tK\"9a#!*\u0005\u0002\u0005%GCAAf!\rY\u0011Q\u0015\u0005\t\u0003+\n)\u000b\"\u0001\u0002PR!\u0011\u0011[Ao!\u0019\t\u0019.!7\u0002B6\u0011\u0011Q\u001b\u0006\u0004\u0003/4\u0011\u0001B;uS2LA!a7\u0002V\n1a)\u001e;ve\u0016D\u0001\"a8\u0002N\u0002\u0007\u0011QW\u0001\u0004e\u0016\f\b\u0002CAr\u0003K#I!!:\u0002\u0019)\u001cxN\u001c*fgB|gn]3\u0015\t\u0005E\u0017q\u001d\u0005\t\u0003?\f\t\u000f1\u0001\u00026\"A\u00111^AS\t\u0013\ti/\u0001\u0007ii6d'+Z:q_:\u001cX\r\u0006\u0003\u0002R\u0006=\b\u0002CAp\u0003S\u0004\r!!.\t\u0011\u0005M\u0018Q\u0015C\u0005\u0003k\f!\"\\1sW\u0016$\u0017\n\u001a7f)\u0011\t90!@\u0011\tq!\u0013\u0011 \t\u0004\u0003w|cBA\u0006\u0001\u0011!\ty0!=A\u0002\u0005]\u0018AA5o\u0011!\u0011\u0019!!*\u0005\n\t\u0015\u0011!\u00043fC\u0012dwnY6fI&#7/\u0006\u0002\u0003\bA!A\u0004\nB\u0005!\r\u0001\"1B\u0005\u0004\u0005\u001b\t\"\u0001\u0002'p]\u001e\u0004")
public class ThreadsHandler
extends Service<Request, Response> {
    public Future<Response> apply(Request req) {
        return HttpUtils$.MODULE$.expectsHtml(req) && !HttpUtils$.MODULE$.expectsJson(req) ? this.htmlResponse(req) : this.jsonResponse(req);
    }

    private Future<Response> jsonResponse(Request req) {
        Map stacks = (Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Thread.getAllStackTraces()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Thread thread = (Thread)tuple2._1();
            StackTraceElement[] stack = (StackTraceElement[])tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((Object)BoxesRunTime.boxToLong((long)thread.getId())).toString()), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"thread"), (Object)thread.getName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"daemon"), (Object)BoxesRunTime.boxToBoolean((boolean)thread.isDaemon())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"state"), (Object)thread.getState()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"priority"), (Object)BoxesRunTime.boxToInteger((int)thread.getPriority())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stack"), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stack)).toSeq().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString(), Seq$.MODULE$.canBuildFrom()))})));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        scala.collection.immutable.Map msg = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"threads"), (Object)stacks)}));
        return HttpUtils$.MODULE$.newOk(JsonConverter$.MODULE$.writeToString(msg), "application/json;charset=UTF-8");
    }

    private Future<Response> htmlResponse(Request req) {
        Seq raw = ((TraversableOnce)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(Thread.getAllStackTraces()).asScala()).toMap(Predef$.MODULE$.$conforms()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Thread thread = (Thread)tuple2._1();
            StackTraceElement[] stack = (StackTraceElement[])tuple2._2();
            ThreadInfo threadInfo = new ThreadInfo(thread, (Seq<StackTraceElement>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stack)).toSeq(), false);
            return threadInfo;
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        Seq<ThreadInfo> withIdle = this.markedIdle((Seq<ThreadInfo>)raw);
        Seq sorted = (Seq)withIdle.sortWith((Function2 & Serializable & scala.Serializable)(x0$3, x1$1) -> BoxesRunTime.boxToBoolean((boolean)ThreadsHandler.$anonfun$htmlResponse$2(x0$3, x1$1)));
        ThreadsView view = new ThreadsView((Seq<ThreadInfo>)sorted, this.deadlockedIds());
        String rendered = view.apply();
        String x$3 = "text/html;charset=UTF-8";
        Buf x$4 = Buf.Utf8$.MODULE$.apply(rendered);
        Version x$5 = HttpUtils$.MODULE$.newResponse$default$1();
        Status x$6 = HttpUtils$.MODULE$.newResponse$default$2();
        Iterable<Tuple2<String, Object>> x$7 = HttpUtils$.MODULE$.newResponse$default$3();
        return HttpUtils$.MODULE$.newResponse(x$5, x$6, x$7, x$3, x$4);
    }

    private Seq<ThreadInfo> markedIdle(Seq<ThreadInfo> in) {
        return (Seq)in.map((Function1 & Serializable & scala.Serializable)info -> {
            ThreadInfo threadInfo;
            if (ThreadsHandler.idleState$1(info.thread().getState()) || ThreadsHandler.idleRunnable$1(info)) {
                boolean x$8 = true;
                Thread x$9 = info.copy$default$1();
                Seq<StackTraceElement> x$10 = info.copy$default$2();
                threadInfo = info.copy(x$9, x$10, x$8);
            } else {
                threadInfo = info;
            }
            return threadInfo;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Seq<Object> deadlockedIds() {
        Option ids = Option$.MODULE$.apply((Object)ManagementFactory.getThreadMXBean().findDeadlockedThreads());
        return (Seq)ids.map((Function1 & Serializable & scala.Serializable)x$2 -> new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(x$2)).toSeq()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$htmlResponse$2(ThreadInfo x0$3, ThreadInfo x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$3, (Object)x1$1);
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        ThreadInfo t1 = (ThreadInfo)tuple2._1();
        ThreadInfo t2 = (ThreadInfo)tuple2._2();
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(t1.isIdle(), t2.isIdle());
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl2 = sp2._2$mcZ$sp();
            if (bl && !bl2) {
                return false;
            }
        }
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl3 = sp2._2$mcZ$sp();
            if (!bl && bl3) {
                return true;
            }
        }
        if (t1.thread().getId() >= t2.thread().getId()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean idleState$1(Thread.State state) {
        Thread.State state2 = state;
        Thread.State state3 = Thread.State.TIMED_WAITING;
        if (state2 == null) {
            if (state3 == null) return true;
        } else if (((Object)((Object)state2)).equals((Object)state3)) return true;
        Thread.State state4 = state;
        Thread.State state5 = Thread.State.WAITING;
        if (state4 != null) {
            if (!((Object)((Object)state4)).equals((Object)state5)) return false;
            return true;
        }
        if (state5 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$markedIdle$1(StackTraceElement elem) {
        return ThreadsHandler$.MODULE$.com$twitter$server$handler$ThreadsHandler$$IdleClassAndMethod().contains((Object)new Tuple2((Object)elem.getClassName(), (Object)elem.getMethodName()));
    }

    private static final boolean idleRunnable$1(ThreadInfo info) {
        return info.stack().headOption().exists((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)ThreadsHandler.$anonfun$markedIdle$1(elem)));
    }

    public static class ThreadInfo
    implements Product,
    scala.Serializable {
        private final Thread thread;
        private final Seq<StackTraceElement> stack;
        private final boolean isIdle;

        public Thread thread() {
            return this.thread;
        }

        public Seq<StackTraceElement> stack() {
            return this.stack;
        }

        public boolean isIdle() {
            return this.isIdle;
        }

        public ThreadInfo copy(Thread thread, Seq<StackTraceElement> stack, boolean isIdle) {
            return new ThreadInfo(thread, stack, isIdle);
        }

        public Thread copy$default$1() {
            return this.thread();
        }

        public Seq<StackTraceElement> copy$default$2() {
            return this.stack();
        }

        public boolean copy$default$3() {
            return this.isIdle();
        }

        public String productPrefix() {
            return "ThreadInfo";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.thread();
                    break;
                }
                case 1: {
                    object = this.stack();
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToBoolean((boolean)this.isIdle());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ThreadInfo;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.thread()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.stack()));
            n = Statics.mix((int)n, (int)(this.isIdle() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ThreadInfo)) return false;
            boolean bl = true;
            if (!bl) return false;
            ThreadInfo threadInfo = (ThreadInfo)x$1;
            Thread thread = this.thread();
            Thread thread2 = threadInfo.thread();
            if (thread == null) {
                if (thread2 != null) {
                    return false;
                }
            } else if (!thread.equals(thread2)) return false;
            Seq<StackTraceElement> seq = this.stack();
            Seq<StackTraceElement> seq2 = threadInfo.stack();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (this.isIdle() != threadInfo.isIdle()) return false;
            if (!threadInfo.canEqual(this)) return false;
            return true;
        }

        public ThreadInfo(Thread thread, Seq<StackTraceElement> stack, boolean isIdle) {
            this.thread = thread;
            this.stack = stack;
            this.isIdle = isIdle;
            Product.$init$((Product)this);
        }
    }
}

