/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.server.lint;

import com.twitter.concurrent.Scheduler;
import com.twitter.concurrent.Scheduler$;
import com.twitter.conversions.DurationOps;
import com.twitter.conversions.DurationOps$;
import com.twitter.util.Duration;
import com.twitter.util.Duration$;
import com.twitter.util.lint.Category;
import com.twitter.util.lint.Issue;
import com.twitter.util.lint.Rule;
import com.twitter.util.lint.Rule$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;

public final class SchedulerBlockingRule$ {
    public static SchedulerBlockingRule$ MODULE$;

    static {
        new SchedulerBlockingRule$();
    }

    public Rule apply() {
        return this.apply((Scheduler)Scheduler$.MODULE$, DurationOps.RichDuration$.MODULE$.seconds$extension(DurationOps$.MODULE$.RichDuration(5L)));
    }

    public Rule apply(Scheduler scheduler, Duration minimumBlocking) {
        return Rule$.MODULE$.apply((Category)Category.Performance$.MODULE$, "Blocking the Scheduler", new StringOps(Predef$.MODULE$.augmentString("\n        |Blocking the Scheduler via usage of `com.twitter.util.Await` can\n        |cause unexpected slowness, a decrease in throughput, and potentially\n        |deadlocks for your application. Developers should instead write\n        |code in terms of the `Future` combinators or do the blocking in\n        |a `com.twitter.util.FuturePool`. To help track down the code\n        |doing the blocking, you can set the System property\n        |`-Dcom.twitter.concurrent.schedulerSampleBlockingFraction=$fraction`\n        |which is defined in `com.twitter.concurrent.LocalScheduler` and it will\n        |log that fraction of blocking stacktraces.\n        |\n        |The metric for this lint rule is exported at \"scheduler/blocking_ms\"\n        |and more details can be found at:\n        |https://twitter.github.io/finagle/guide/Metrics.html#scheduler\n      ")).stripMargin(), (Function0 & java.io.Serializable & Serializable)() -> {
            Duration blocking = Duration$.MODULE$.fromNanoseconds(scheduler.blockingTimeNanos());
            return blocking.$less$eq((Object)minimumBlocking) ? Nil$.MODULE$ : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Issue[]{new Issue(new StringBuilder(48).append("The Scheduler has been blocked for ").append(blocking.inMillis()).append(" milliseconds").toString())}));
        });
    }

    private SchedulerBlockingRule$() {
        MODULE$ = this;
    }
}

