/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.server.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.twitter.finagle.stats.CounterSchema;
import com.twitter.finagle.stats.GaugeSchema;
import com.twitter.finagle.stats.HistogramSchema;
import com.twitter.finagle.stats.MetricSchema;
import com.twitter.finagle.stats.metadataScopeSeparator$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Serializable;
import scala.collection.GenTraversable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction1;

public final class SchemaSerializer$
extends StdSerializer<MetricSchema> {
    public static SchemaSerializer$ MODULE$;

    static {
        new SchemaSerializer$();
    }

    public void serialize(MetricSchema metricSchema, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        String string;
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("name", metricSchema.metricBuilder().name().mkString(metadataScopeSeparator$.MODULE$.apply()));
        jsonGenerator.writeArrayFieldStart("relative_name");
        Seq seq = metricSchema.metricBuilder().relativeName();
        GenTraversable genTraversable = Seq$.MODULE$.empty();
        if (seq == null ? genTraversable != null : !seq.equals(genTraversable)) {
            metricSchema.metricBuilder().relativeName().foreach((Function1 & java.io.Serializable & Serializable)segment -> {
                jsonGenerator.writeString(segment);
                return BoxedUnit.UNIT;
            });
        } else {
            metricSchema.metricBuilder().name().foreach((Function1 & java.io.Serializable & Serializable)segment -> {
                jsonGenerator.writeString(segment);
                return BoxedUnit.UNIT;
            });
        }
        jsonGenerator.writeEndArray();
        MetricSchema metricSchema2 = metricSchema;
        if (metricSchema2 instanceof CounterSchema) {
            string = "counter";
        } else if (metricSchema2 instanceof GaugeSchema) {
            string = "gauge";
        } else if (metricSchema2 instanceof HistogramSchema) {
            string = "histogram";
        } else {
            throw new MatchError((Object)metricSchema2);
        }
        String dataType = string;
        jsonGenerator.writeStringField("kind", dataType);
        jsonGenerator.writeObjectFieldStart("source");
        jsonGenerator.writeStringField("class", (String)metricSchema.metricBuilder().sourceClass().getOrElse((Function0 & java.io.Serializable & Serializable)() -> "Unspecified"));
        jsonGenerator.writeStringField("category", metricSchema.metricBuilder().role().toString());
        jsonGenerator.writeStringField("process_path", (String)metricSchema.metricBuilder().processPath().getOrElse((Function0 & java.io.Serializable & Serializable)() -> "Unspecified"));
        jsonGenerator.writeEndObject();
        jsonGenerator.writeStringField("description", metricSchema.metricBuilder().description());
        jsonGenerator.writeStringField("unit", metricSchema.metricBuilder().units().toString());
        jsonGenerator.writeStringField("verbosity", metricSchema.metricBuilder().verbosity().toString());
        jsonGenerator.writeBooleanField("key_indicator", metricSchema.metricBuilder().keyIndicator());
        if (metricSchema instanceof HistogramSchema) {
            jsonGenerator.writeArrayFieldStart("buckets");
            metricSchema.metricBuilder().percentiles().foreach((Function1)(JFunction1.mcVD.sp & java.io.Serializable & Serializable)bucket -> jsonGenerator.writeNumber(bucket));
            jsonGenerator.writeEndArray();
        }
        jsonGenerator.writeEndObject();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private SchemaSerializer$() {
        super(MetricSchema.class);
        MODULE$ = this;
    }
}

