/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.classpreloader;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Writer;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;

public class ClassPreloader {
    private static SortedSet<String> classes = Collections.synchronizedSortedSet(new TreeSet());

    public static void premain(final String string, Instrumentation instrumentation) {
        try {
            Closeable closeable;
            System.err.println("PRELOAD: Agent initialized using " + string);
            File file = new File(string);
            if (file.exists()) {
                Object object;
                closeable = new BufferedReader(new FileReader(string));
                while ((object = ((BufferedReader)closeable).readLine()) != null) {
                    try {
                        ClassPreloader.class.getClassLoader().loadClass((String)object);
                        classes.add((String)object);
                    }
                    catch (Throwable throwable) {}
                }
                ((BufferedReader)closeable).close();
            }
            closeable = new BufferedWriter(new FileWriter(string));
            for (String string2 : classes) {
                ((Writer)closeable).write(string2);
                ((Writer)closeable).write("\n");
            }
            ((BufferedWriter)closeable).close();
            instrumentation.addTransformer(new ClassFileTransformer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public byte[] transform(ClassLoader classLoader, String string3, Class<?> clazz, ProtectionDomain protectionDomain, byte[] byArray) throws IllegalClassFormatException {
                    if (ClassPreloader.skip(string3)) {
                        return null;
                    }
                    String string2 = string3.replace("/", ".");
                    if (classes.contains(string2)) {
                        return null;
                    }
                    Class<ClassPreloader> clazz2 = ClassPreloader.class;
                    synchronized (ClassPreloader.class) {
                        try {
                            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string, true));
                            bufferedWriter.write(string2);
                            bufferedWriter.write("\n");
                            bufferedWriter.close();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        return null;
                    }
                }
            }, true);
            System.err.println("PRELOAD: Loaded " + classes.size() + " classes");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static boolean skip(String string) {
        return string.startsWith("$Proxy") || string.startsWith("sun/reflect/Generated") || string.startsWith("java/") || string.contains("$$");
    }
}

