/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.concurrent;

import java.util.ArrayDeque;
import scala.Predef$;
import scala.ScalaObject;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00054q!\u0001\u0002\u0011\u0002G\u0005\u0011BA\u0005TG\",G-\u001e7fe*\u00111\u0001B\u0001\u000bG>t7-\u001e:sK:$(BA\u0003\u0007\u0003\u001d!x/\u001b;uKJT\u0011aB\u0001\u0004G>l7\u0001A\n\u0003\u0001)\u0001\"a\u0003\t\u000e\u00031Q!!\u0004\b\u0002\t1\fgn\u001a\u0006\u0002\u001f\u0005!!.\u0019<b\u0013\t\tBB\u0001\u0004PE*,7\r\u001e\u0005\u0006'\u00011\t\u0001F\u0001\u0007gV\u0014W.\u001b;\u0015\u0005UY\u0002C\u0001\f\u001a\u001b\u00059\"\"\u0001\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005i9\"\u0001B+oSRDQ\u0001\b\nA\u0002u\t\u0011A\u001d\t\u0003\u0017yI!a\b\u0007\u0003\u0011I+hN\\1cY\u0016DQ!\t\u0001\u0007\u0002\t\nQA\u001a7vg\"$\u0012!F\u0004\u0006I\tA)!J\u0001\n'\u000eDW\rZ;mKJ\u0004\"AJ\u0014\u000e\u0003\t1Q!\u0001\u0002\t\u0006!\u001aBa\n\u0006*UA\u0011a\u0005\u0001\t\u0003--J!\u0001L\f\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\u0006]\u001d\"\taL\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0015Bq!M\u0014C\u0002\u0013%!'A\u0003m_\u000e\fG.F\u00014%\t!\u0004H\u0002\u00036m\u0001\u0019$\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0004BB\u001c(A\u0003%1'\u0001\u0004m_\u000e\fG\u000e\t\t\u0004\u0017eJ\u0013B\u0001\u001e\r\u0005-!\u0006N]3bI2{7-\u00197\t\u000bq\"D\u0011I\u001f\u0002\u0019%t\u0017\u000e^5bYZ\u000bG.^3\u0015\u0003y\u0002\"a\u0010!\u000e\u0003\u001d2A!Q\u0014\u0005\u0005\nqAj\\2bYN\u001b\u0007.\u001a3vY\u0016\u00148\u0003\u0002!\u000bS)BQA\f!\u0005\u0002uBa!\u0012!!B\u0013i\u0012A\u0001:1\u0011\u00199\u0005\t)Q\u0005;\u0005\u0011!/\r\u0005\u0007\u0013\u0002\u0003\u000b\u0015B\u000f\u0002\u0005I\u0014\u0004BB&AA\u0003%A*\u0001\u0002sgB\u0019Q\nU\u000f\u000e\u00039S!a\u0014\b\u0002\tU$\u0018\u000e\\\u0005\u0003#:\u0013!\"\u0011:sCf$U-];f\u0011\u0019\u0019\u0006\t)Q\u0005)\u00069!/\u001e8oS:<\u0007C\u0001\fV\u0013\t1vCA\u0004C_>dW-\u00198\t\u000bM\u0001E\u0011\u0001-\u0015\u0005UI\u0006\"\u0002\u000fX\u0001\u0004i\u0002\"B\u0011A\t\u0003\u0011\u0003B\u0002/AA\u0013%!%A\u0002sk:DQaE\u0014\u0005\u0002y#\"!F0\t\u000bqi\u0006\u0019A\u000f\t\u000b\u0005:C\u0011\u0001\u0012")
public interface Scheduler {
    public void submit(Runnable var1);

    public void flush();

    public static class LocalScheduler
    implements Scheduler,
    ScalaObject {
        private Runnable r0 = null;
        private Runnable r1 = null;
        private Runnable r2 = null;
        private final ArrayDeque<Runnable> rs = new ArrayDeque();
        private boolean running = false;

        public void submit(Runnable r) {
            Predef$.MODULE$.assert(r != null);
            if (this.r0 == null) {
                this.r0 = r;
            } else if (this.r1 == null) {
                this.r1 = r;
            } else if (this.r2 == null) {
                this.r2 = r;
            } else {
                this.rs.addLast(r);
            }
            if (!this.running) {
                this.run();
            }
        }

        public void flush() {
            if (this.running) {
                this.run();
            }
        }

        private void run() {
            boolean save = this.running;
            this.running = true;
            try {
                while (true) {
                    if (this.r0 == null) {
                        return;
                    }
                    Runnable r = this.r0;
                    this.r0 = this.r1;
                    this.r1 = this.r2;
                    this.r2 = this.rs.isEmpty() ? null : this.rs.removeFirst();
                    r.run();
                }
            }
            finally {
                this.running = save;
            }
        }
    }
}

