/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.util;

import com.twitter.util.Duration;
import com.twitter.util.Duration$;
import com.twitter.util.Time;
import com.twitter.util.Time$;
import com.twitter.util.TimeLike;
import com.twitter.util.TimeLikeOps;
import com.twitter.util.TimeLikeOps$Finite$;
import com.twitter.util.TimeLikeOps$Nanoseconds$;
import com.twitter.util.TimeLikeOps$class;
import java.util.concurrent.TimeUnit;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest$;
import scala.reflect.OptManifest;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Duration$
implements TimeLikeOps<Duration>,
ScalaObject,
Serializable {
    public static final Duration$ MODULE$;
    private final long NanosPerMicrosecond;
    private final long NanosPerMillisecond;
    private final long NanosPerSecond;
    private final long NanosPerMinute;
    private final long NanosPerHour;
    private final long NanosPerDay;
    private final Duration Top;
    private final Duration Bottom;
    private final Duration Undefined;
    private final Duration zero;
    private final Duration forever;
    private final Duration eternity;
    private final Duration MaxValue;
    private final Duration MinValue;
    private final Seq<TimeUnit> com$twitter$util$Duration$$timeUnits;
    private final Map<String, TimeUnit> com$twitter$util$Duration$$nameToUnit;
    private final Regex SingleDurationRegex;
    private final Regex FullDurationRegex;
    private final TimeLike Zero;
    private volatile TimeLikeOps$Nanoseconds$ Nanoseconds$module;
    private volatile TimeLikeOps$Finite$ Finite$module;

    static {
        new Duration$();
    }

    @Override
    public TimeLike Zero() {
        return this.Zero;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final TimeLikeOps$Nanoseconds$ Nanoseconds() {
        if (this.Nanoseconds$module != null) return this.Nanoseconds$module;
        Duration$ duration$ = this;
        synchronized (duration$) {
            if (this.Nanoseconds$module == null) {
                this.Nanoseconds$module = new TimeLikeOps$Nanoseconds$(this);
            }
            return this.Nanoseconds$module;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final TimeLikeOps$Finite$ Finite() {
        if (this.Finite$module != null) return this.Finite$module;
        Duration$ duration$ = this;
        synchronized (duration$) {
            if (this.Finite$module == null) {
                this.Finite$module = new TimeLikeOps$Finite$(this);
            }
            return this.Finite$module;
        }
    }

    @Override
    public void com$twitter$util$TimeLikeOps$_setter_$Zero_$eq(TimeLike timeLike) {
        this.Zero = timeLike;
    }

    @Override
    public TimeLike fromMicroseconds(long micros) {
        return TimeLikeOps$class.fromMicroseconds(this, micros);
    }

    @Override
    public Duration fromNanoseconds(long nanoseconds) {
        return new Duration(nanoseconds);
    }

    @Override
    public Duration fromSeconds(int seconds) {
        return (Duration)TimeLikeOps$class.fromSeconds(this, seconds);
    }

    @Override
    public Duration fromMilliseconds(long millis) {
        return (Duration)TimeLikeOps$class.fromMilliseconds(this, millis);
    }

    public long NanosPerMicrosecond() {
        return this.NanosPerMicrosecond;
    }

    public long NanosPerMillisecond() {
        return this.NanosPerMillisecond;
    }

    public long NanosPerSecond() {
        return this.NanosPerSecond;
    }

    public long NanosPerMinute() {
        return this.NanosPerMinute;
    }

    public long NanosPerHour() {
        return this.NanosPerHour;
    }

    public long NanosPerDay() {
        return this.NanosPerDay;
    }

    public Duration fromTimeUnit(long value, TimeUnit unit2) {
        return this.apply(value, unit2);
    }

    public Duration apply(long value, TimeUnit unit2) {
        long ns = TimeUnit.NANOSECONDS.convert(value, unit2);
        return this.fromNanoseconds(ns);
    }

    public Duration since(Time time2) {
        return Time$.MODULE$.now().since(time2);
    }

    @Override
    public Duration Top() {
        return this.Top;
    }

    @Override
    public Duration Bottom() {
        return this.Bottom;
    }

    @Override
    public Duration Undefined() {
        return this.Undefined;
    }

    public Duration zero() {
        return this.zero;
    }

    public Duration forever() {
        return this.forever;
    }

    public Duration eternity() {
        return this.eternity;
    }

    public Duration MaxValue() {
        return this.MaxValue;
    }

    public Duration MinValue() {
        return this.MinValue;
    }

    public <T> Tuple2<T, Duration> inMilliseconds(Function0<T> f) {
        Time start2 = Time$.MODULE$.now();
        Object rv = f.apply();
        Duration duration = Time$.MODULE$.now().$minus(start2);
        return new Tuple2(rv, (Object)duration);
    }

    public <T> Tuple2<T, Duration> inNanoseconds(Function0<T> f) {
        long start2 = System.nanoTime();
        Object rv = f.apply();
        Duration duration = this.fromNanoseconds(System.nanoTime() - start2);
        return new Tuple2(rv, (Object)duration);
    }

    public final Seq<TimeUnit> com$twitter$util$Duration$$timeUnits() {
        return this.com$twitter$util$Duration$$timeUnits;
    }

    public final Map<String, TimeUnit> com$twitter$util$Duration$$nameToUnit() {
        return this.com$twitter$util$Duration$$nameToUnit;
    }

    private Regex SingleDurationRegex() {
        return this.SingleDurationRegex;
    }

    private Regex FullDurationRegex() {
        return this.FullDurationRegex;
    }

    public Duration parse(String s) {
        List list;
        String ss;
        String string2 = ss = s.toLowerCase();
        Option option = this.FullDurationRegex().unapplySeq((Object)string2);
        if (!option.isEmpty() && ((list = (List)option.get()) == null ? false : list.lengthCompare(0) >= 0)) {
            return (Duration)this.SingleDurationRegex().findAllIn((CharSequence)ss).matchData().zipWithIndex().map((Function1)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Duration apply(Tuple2<Regex.Match, Object> tuple2) {
                    Tuple2<Regex.Match, Object> tuple22;
                    block7: {
                        List list;
                        block8: {
                            block9: {
                                block10: {
                                    block11: {
                                        block12: {
                                            block13: {
                                                Option option;
                                                String unitStr;
                                                block18: {
                                                    Duration duration;
                                                    String string2;
                                                    Duration duration2;
                                                    String signStr;
                                                    int i$1;
                                                    block15: {
                                                        String numStr;
                                                        block17: {
                                                            String string3;
                                                            block16: {
                                                                block14: {
                                                                    String special;
                                                                    tuple22 = tuple2;
                                                                    if (tuple22 == null) break block7;
                                                                    Regex.Match match = (Regex.Match)tuple22._1();
                                                                    int n = BoxesRunTime.unboxToInt((Object)tuple22._2());
                                                                    Regex.Match m = match;
                                                                    i$1 = n;
                                                                    list = m.subgroups();
                                                                    if (!(list instanceof .colon.colon)) break block8;
                                                                    .colon.colon colon2 = (.colon.colon)list;
                                                                    if (colon2 == null) break block9;
                                                                    String string4 = (String)colon2.hd$1();
                                                                    List list2 = colon2.tl$1();
                                                                    if (!(list2 instanceof .colon.colon)) break block10;
                                                                    .colon.colon colon3 = (.colon.colon)list2;
                                                                    String string5 = (String)colon3.hd$1();
                                                                    List list3 = colon3.tl$1();
                                                                    if (!(list3 instanceof .colon.colon)) break block11;
                                                                    .colon.colon colon4 = (.colon.colon)list3;
                                                                    String string6 = (String)colon4.hd$1();
                                                                    List list4 = colon4.tl$1();
                                                                    if (!(list4 instanceof .colon.colon)) break block12;
                                                                    .colon.colon colon5 = (.colon.colon)list4;
                                                                    String string7 = (String)colon5.hd$1();
                                                                    Nil$ nil$ = Nil$.MODULE$;
                                                                    List list5 = colon5.tl$1();
                                                                    if (nil$ != null ? !nil$.equals(list5) : list5 != null) break block13;
                                                                    Tuple4 tuple4 = new Tuple4((Object)string4, (Object)string5, (Object)string6, (Object)string7);
                                                                    signStr = (String)tuple4._1();
                                                                    numStr = (String)tuple4._2();
                                                                    unitStr = (String)tuple4._3();
                                                                    String string8 = string3 = (special = (String)tuple4._4());
                                                                    String string9 = "top";
                                                                    if (string8 != null ? !string8.equals(string9) : string9 != null) break block14;
                                                                    duration2 = Duration$.MODULE$.Top();
                                                                    break block15;
                                                                }
                                                                String string10 = string3;
                                                                String string11 = "bottom";
                                                                if (string10 != null ? !string10.equals(string11) : string11 != null) break block16;
                                                                duration2 = Duration$.MODULE$.Bottom();
                                                                break block15;
                                                            }
                                                            String string12 = string3;
                                                            String string13 = "undefined";
                                                            if (string12 != null ? !string12.equals(string13) : string13 != null) break block17;
                                                            duration2 = Duration$.MODULE$.Undefined();
                                                            break block15;
                                                        }
                                                        option = Duration$.MODULE$.com$twitter$util$Duration$$nameToUnit().get((Object)unitStr);
                                                        if (!(option instanceof Some)) break block18;
                                                        TimeUnit u = (TimeUnit)((Object)((Some)option).x());
                                                        duration2 = Duration$.MODULE$.apply(Predef$.MODULE$.augmentString(numStr).toLong(), u);
                                                    }
                                                    Duration absDuration = duration2;
                                                    String string14 = string2 = signStr;
                                                    String string15 = "-";
                                                    if (!(string14 != null ? !string14.equals(string15) : string15 != null)) {
                                                        duration = absDuration.unary_$minus();
                                                    } else {
                                                        String string16 = string2;
                                                        String string17 = "";
                                                        if (!(string16 != null ? !string16.equals(string17) : string17 != null) && this.gd1$1(i$1)) {
                                                            throw new NumberFormatException("Expected a sign between durations");
                                                        }
                                                        duration = absDuration;
                                                    }
                                                    return duration;
                                                }
                                                None$ none$ = None$.MODULE$;
                                                Option option2 = option;
                                                if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
                                                    throw new NumberFormatException(new StringBuilder().append((Object)"Invalid unit: ").append((Object)unitStr).toString());
                                                }
                                                throw new MatchError((Object)option);
                                            }
                                            throw new MatchError((Object)list);
                                        }
                                        throw new MatchError((Object)list);
                                    }
                                    throw new MatchError((Object)list);
                                }
                                throw new MatchError((Object)list);
                            }
                            throw new MatchError((Object)list);
                        }
                        throw new MatchError((Object)list);
                    }
                    throw new MatchError(tuple22);
                }

                private final boolean gd1$1(int n) {
                    return n > 0;
                }
            }).reduce((Function2)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Duration apply(Duration duration, Duration duration2) {
                    return (Duration)duration.$plus(duration2);
                }
            });
        }
        throw new NumberFormatException(new StringBuilder().append((Object)"Invalid duration: ").append((Object)s).toString());
    }

    public Object readResolve() {
        return MODULE$;
    }

    private Duration$() {
        MODULE$ = this;
        TimeLikeOps$class.$init$(this);
        this.NanosPerMicrosecond = 1000L;
        this.NanosPerMillisecond = this.NanosPerMicrosecond() * 1000L;
        this.NanosPerSecond = this.NanosPerMillisecond() * 1000L;
        this.NanosPerMinute = this.NanosPerSecond() * 60L;
        this.NanosPerHour = this.NanosPerMinute() * 60L;
        this.NanosPerDay = this.NanosPerHour() * 24L;
        this.Top = new anon.1();
        this.Bottom = new anon.2();
        this.Undefined = new anon.3();
        this.zero = (Duration)this.Zero();
        this.forever = this.Top();
        this.eternity = this.Top();
        this.MaxValue = this.Top();
        this.MinValue = (Duration)this.Zero();
        this.com$twitter$util$Duration$$timeUnits = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TimeUnit[]{TimeUnit.DAYS, TimeUnit.HOURS, TimeUnit.MINUTES, TimeUnit.SECONDS, TimeUnit.MILLISECONDS, TimeUnit.MICROSECONDS, TimeUnit.NANOSECONDS}));
        this.com$twitter$util$Duration$$nameToUnit = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])TimeUnit.values()).flatMap((Function1)new anonfun.1(), Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(Tuple2.class, (OptManifest)ClassManifest$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[]{ClassManifest$.MODULE$.classType(TimeUnit.class)}))))).toMap(Predef$.MODULE$.conforms());
        this.SingleDurationRegex = Predef$.MODULE$.augmentString("\\s*([+-]?)\\s*(?:([0-9]+)\\.([a-z]+)|duration\\.(top|bottom|undefined))").r();
        this.FullDurationRegex = Predef$.MODULE$.augmentString(new StringBuilder().append((Object)"(").append((Object)this.SingleDurationRegex().pattern().pattern()).append((Object)")+\\s*").toString()).r();
    }
}

