/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.util;

import com.twitter.util.Duration;
import com.twitter.util.Time;
import com.twitter.util.Time$;
import com.twitter.util.TimeControl;
import com.twitter.util.TimeFormat;
import com.twitter.util.TimeLike;
import com.twitter.util.TimeLikeOps;
import com.twitter.util.TimeLikeOps$Finite$;
import com.twitter.util.TimeLikeOps$Nanoseconds$;
import com.twitter.util.TimeLikeOps$class;
import java.util.Date;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.runtime.BoxedUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Time$
implements TimeLikeOps<Time>,
ScalaObject,
Serializable {
    public static final Time$ MODULE$;
    private final Time Top;
    private final Time Bottom;
    private final Time Undefined;
    private final Time epoch;
    private final Time never;
    private final TimeFormat com$twitter$util$Time$$defaultFormat;
    private final TimeFormat rssFormat;
    private final long nanoTimeOffset;
    private Function0<Time> fn;
    private final TimeLike Zero;
    private volatile TimeLikeOps$Nanoseconds$ Nanoseconds$module;
    private volatile TimeLikeOps$Finite$ Finite$module;

    static {
        new Time$();
    }

    @Override
    public TimeLike Zero() {
        return this.Zero;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final TimeLikeOps$Nanoseconds$ Nanoseconds() {
        if (this.Nanoseconds$module != null) return this.Nanoseconds$module;
        Time$ time$2 = this;
        synchronized (time$2) {
            if (this.Nanoseconds$module == null) {
                this.Nanoseconds$module = new TimeLikeOps$Nanoseconds$(this);
            }
            return this.Nanoseconds$module;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final TimeLikeOps$Finite$ Finite() {
        if (this.Finite$module != null) return this.Finite$module;
        Time$ time$2 = this;
        synchronized (time$2) {
            if (this.Finite$module == null) {
                this.Finite$module = new TimeLikeOps$Finite$(this);
            }
            return this.Finite$module;
        }
    }

    @Override
    public void com$twitter$util$TimeLikeOps$_setter_$Zero_$eq(TimeLike timeLike) {
        this.Zero = timeLike;
    }

    @Override
    public TimeLike fromMicroseconds(long micros) {
        return TimeLikeOps$class.fromMicroseconds(this, micros);
    }

    @Override
    public Time fromNanoseconds(long nanoseconds) {
        return new Time(nanoseconds);
    }

    @Override
    public Time fromSeconds(int seconds) {
        return (Time)TimeLikeOps$class.fromSeconds(this, seconds);
    }

    @Override
    public Time fromMilliseconds(long millis) {
        return (Time)TimeLikeOps$class.fromMilliseconds(this, millis);
    }

    @Override
    public Time Top() {
        return this.Top;
    }

    @Override
    public Time Bottom() {
        return this.Bottom;
    }

    @Override
    public Time Undefined() {
        return this.Undefined;
    }

    public Time now() {
        return (Time)this.fn().apply();
    }

    public Time epoch() {
        return this.epoch;
    }

    public Time never() {
        return this.never;
    }

    public final TimeFormat com$twitter$util$Time$$defaultFormat() {
        return this.com$twitter$util$Time$$defaultFormat;
    }

    private TimeFormat rssFormat() {
        return this.rssFormat;
    }

    public long nanoTimeOffset() {
        return this.nanoTimeOffset;
    }

    public Function0<Time> fn() {
        return this.fn;
    }

    public void fn_$eq(Function0<Time> function0) {
        this.fn = function0;
    }

    public Time apply(long millis) {
        return this.fromMilliseconds(millis);
    }

    public Time apply(Date date) {
        return this.fromMilliseconds(date.getTime());
    }

    public Time at(String datetime) {
        return this.com$twitter$util$Time$$defaultFormat().parse(datetime);
    }

    public <A> A withTimeFunction(Function0<Time> timeFunction, Function1<TimeControl, A> body) {
        Function0<Time> prevFn = this.fn();
        Object exceptionResult1 = null;
        try {
            TimeControl timeControl = new TimeControl(){

                public void set(Time time$1) {
                    Time$.MODULE$.fn_$eq((Function0<Time>)new Serializable(this, time$1){
                        public static final long serialVersionUID;
                        private final Time time$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final Time apply() {
                            return this.time$1;
                        }
                        {
                            this.time$1 = time2;
                        }
                    });
                }

                public void advance(Duration delta) {
                    Time newTime$1 = (Time)Time$.MODULE$.now().$plus(delta);
                    Time$.MODULE$.fn_$eq((Function0<Time>)new Serializable(this, newTime$1){
                        public static final long serialVersionUID;
                        private final Time newTime$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final Time apply() {
                            return this.newTime$1;
                        }
                        {
                            this.newTime$1 = time2;
                        }
                    });
                }
            };
            this.fn_$eq(timeFunction);
            exceptionResult1 = body.apply((Object)timeControl);
            return (A)exceptionResult1;
        }
        finally {
            this.fn_$eq(prevFn);
        }
    }

    public <A> A withTimeAt(Time time$2, Function1<TimeControl, A> body) {
        return this.withTimeFunction((Function0<Time>)new Serializable(time$2){
            public static final long serialVersionUID;
            private final Time time$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Time apply() {
                return this.time$2;
            }
            {
                this.time$2 = time2;
            }
        }, body);
    }

    public <A> A withCurrentTimeFrozen(Function1<TimeControl, A> body) {
        return this.withTimeAt(this.now(), body);
    }

    public Duration measure(Function0<BoxedUnit> f) {
        Time begin = this.now();
        f.apply$mcV$sp();
        return this.now().$minus(begin);
    }

    public Duration measureMany(int n$1, Function0<BoxedUnit> f$1) {
        Predef$.MODULE$.require(n$1 > 0);
        Duration d = this.measure((Function0<BoxedUnit>)new Serializable(n$1, f$1){
            public static final long serialVersionUID;
            private final int n$1;
            private final Function0 f$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                for (int i = 0; i < this.n$1; ++i) {
                    this.f$1.apply$mcV$sp();
                }
            }
            {
                this.n$1 = n;
                this.f$1 = function0;
            }
        });
        return d.$div(n$1);
    }

    public Time fromRss(String rss) {
        return this.rssFormat().parse(rss);
    }

    public Object readResolve() {
        return MODULE$;
    }

    private Time$() {
        MODULE$ = this;
        TimeLikeOps$class.$init$(this);
        this.Top = new anon.1();
        this.Bottom = new anon.2();
        this.Undefined = new anon.3();
        this.epoch = this.fromNanoseconds(0L);
        this.never = this.Top();
        this.com$twitter$util$Time$$defaultFormat = new TimeFormat("yyyy-MM-dd HH:mm:ss Z");
        this.rssFormat = new TimeFormat("E, dd MMM yyyy HH:mm:ss Z");
        this.nanoTimeOffset = System.currentTimeMillis() * 1000000L - System.nanoTime();
        this.fn = new anonfun.2();
    }
}

