/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.connect.client;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public final class Creds {
    private final String appKey;
    private final String token;

    public static Builder newBuilder() {
        return new Builder();
    }

    private Creds(String appKey, String token) {
        this.appKey = appKey;
        this.token = token;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public String getToken() {
        return this.token;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Creds)) {
            return false;
        }
        Creds creds = (Creds)o;
        return Objects.equals(this.appKey, creds.appKey) && Objects.equals(this.token, creds.token);
    }

    public int hashCode() {
        return Objects.hash(this.appKey, this.token);
    }

    public static final class Builder {
        private String appKey;
        private String token;

        private Builder() {
        }

        public Builder setAppKey(String appKey) {
            this.appKey = appKey;
            return this;
        }

        public Builder setToken(String token) {
            this.token = token;
            return this;
        }

        public Creds build() {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.appKey), (Object)"App key is required");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.token), (Object)"Non-blank token value is required");
            return new Creds(this.appKey, this.token);
        }
    }
}

