/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.connect.client;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.cookie.Cookie;
import com.ning.http.client.cookie.CookieDecoder;
import com.urbanairship.connect.client.Creds;
import com.urbanairship.connect.client.FatalExceptionHandler;
import com.urbanairship.connect.client.StreamQueryDescriptor;
import com.urbanairship.connect.client.consume.MobileEventStreamBodyConsumer;
import com.urbanairship.connect.client.consume.MobileEventStreamConnectFuture;
import com.urbanairship.connect.client.consume.MobileEventStreamResponseHandler;
import com.urbanairship.connect.client.consume.StatusAndHeaders;
import com.urbanairship.connect.client.model.GsonUtil;
import com.urbanairship.connect.java8.Consumer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class MobileEventStream
implements AutoCloseable {
    private static final Logger log = LogManager.getLogger(MobileEventStream.class);
    public static final String X_UA_APPKEY = "X-UA-Appkey";
    private static final String ACCEPT_HEADER = "application/vnd.urbanairship+x-ndjson; version=3;";
    private static final Gson GSON = GsonUtil.getGson();
    private final StreamQueryDescriptor descriptor;
    private final AsyncHttpClient client;
    private final Consumer<String> eventConsumer;
    private final String url;
    private final FatalExceptionHandler fatalExceptionHandler;
    private final Object stateLock = new Object();
    private volatile Connection connection = null;
    private volatile CountDownLatch bodyConsumeLatch = null;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public MobileEventStream(StreamQueryDescriptor descriptor, AsyncHttpClient client, Consumer<String> eventConsumer, String url, FatalExceptionHandler fatalExceptionHandler) {
        this.descriptor = descriptor;
        this.client = client;
        this.eventConsumer = eventConsumer;
        this.url = url;
        this.fatalExceptionHandler = fatalExceptionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(long maxConnectWaitTime, TimeUnit unit) throws InterruptedException {
        Object object = this.stateLock;
        synchronized (object) {
            Preconditions.checkState((this.connection == null ? 1 : 0) != 0);
            try {
                this.connection = this.connect(maxConnectWaitTime, unit, Collections.emptyList());
            }
            catch (ExecutionException e) {
                throw new RuntimeException("Failure attempting to connect to mobile event stream for app " + this.getAppKey(), e);
            }
            catch (TimeoutException e) {
                throw new RuntimeException("Timed out waiting to establish connection to mobile event stream for app " + this.getAppKey());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consume(long maxConsumeTime, TimeUnit unit) throws InterruptedException {
        Object object = this.stateLock;
        synchronized (object) {
            Preconditions.checkState((this.connection != null && !this.closed.get() ? 1 : 0) != 0);
            this.bodyConsumeLatch = new CountDownLatch(1);
            Runnable bodyConsumeLatchRunnable = new Runnable(){

                @Override
                public void run() {
                    MobileEventStream.this.bodyConsumeLatch.countDown();
                }
            };
            this.connection.future.addListener(bodyConsumeLatchRunnable, MoreExecutors.directExecutor());
        }
        try {
            Optional<Throwable> error;
            this.connection.handler.consumeBody();
            if (!this.bodyConsumeLatch.await(maxConsumeTime, unit)) {
                log.debug((Object)("Hit max consume time for stream for app " + this.getAppKey()));
            }
            if ((error = this.connection.handler.getError()).isPresent()) {
                throw new RuntimeException("Error occurred consuming stream for app " + this.getAppKey(), (Throwable)error.get());
            }
        }
        finally {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.closed.compareAndSet(false, true)) {
                return;
            }
            if (this.bodyConsumeLatch != null) {
                this.bodyConsumeLatch.countDown();
            }
            if (this.connection != null) {
                try {
                    this.connection.handler.stop();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                this.connection.future.done();
            }
        }
    }

    @Override
    public void close() throws Exception {
        this.cleanup();
    }

    private Connection connect(long maxConnectTime, TimeUnit unit, Collection<Cookie> cookies) throws InterruptedException, ExecutionException, TimeoutException {
        AsyncHttpClient.BoundRequestBuilder request = this.buildRequest(cookies);
        MobileEventStreamConnectFuture connectFuture = new MobileEventStreamConnectFuture();
        MobileEventStreamBodyConsumer consumer = new MobileEventStreamBodyConsumer(this.eventConsumer);
        MobileEventStreamResponseHandler responseHandler = new MobileEventStreamResponseHandler(consumer, connectFuture);
        ListenableFuture future = request.execute((AsyncHandler)responseHandler);
        StatusAndHeaders statusAndHeaders = (StatusAndHeaders)connectFuture.get(maxConnectTime, unit);
        int status = statusAndHeaders.getStatusCode();
        if (status == 200) {
            return new Connection((ListenableFuture<Boolean>)future, responseHandler);
        }
        responseHandler.stop();
        future.done();
        if (399 < status && status < 500) {
            this.fatalExceptionHandler.handle(new RuntimeException(String.format("Received status code (%d) from a bad request for app %s", status, this.getAppKey())));
        }
        if (status != 307) {
            throw new RuntimeException(String.format("Received unexpected status code (%d) from request for stream for app %s", status, this.getAppKey()));
        }
        return this.handleRedirect(maxConnectTime, unit, statusAndHeaders);
    }

    private AsyncHttpClient.BoundRequestBuilder buildRequest(Collection<Cookie> cookies) {
        byte[] query = this.getQuery();
        AsyncHttpClient.BoundRequestBuilder request = this.client.preparePost(this.url).addHeader("Accept", ACCEPT_HEADER).addHeader("Content-Length", Integer.toString(query.length));
        Map<String, String> authHeaders = this.getAuthHeaders(this.descriptor.getCreds());
        for (Map.Entry<String, String> entry : authHeaders.entrySet()) {
            request.addHeader(entry.getKey(), entry.getValue());
        }
        for (Cookie cookie : cookies) {
            request.addCookie(cookie);
        }
        request.setBody(query);
        return request;
    }

    private Connection handleRedirect(long maxConnectTime, TimeUnit unit, StatusAndHeaders statusAndHeaders) throws InterruptedException, ExecutionException, TimeoutException {
        List<String> values = statusAndHeaders.getHeaders().get("Set-Cookie");
        if (values == null || values.isEmpty()) {
            throw new RuntimeException("Received redirect response with no 'Set-Cookie' header in response!");
        }
        String value = values.get(0);
        Cookie cookie = CookieDecoder.decode((String)value);
        if (cookie == null) {
            throw new RuntimeException("Received redirect response with unparsable 'Set-Cookie' value - " + value);
        }
        return this.connect(maxConnectTime, unit, (Collection<Cookie>)ImmutableList.of((Object)cookie));
    }

    private Map<String, String> getAuthHeaders(Creds creds) {
        return ImmutableMap.of((Object)"Authorization", (Object)("Bearer " + creds.getToken()), (Object)X_UA_APPKEY, (Object)creds.getAppKey());
    }

    private byte[] getQuery() {
        HashMap<String, Object> body = new HashMap<String, Object>();
        if (!this.descriptor.getOffset().isPresent()) {
            body.put("start", "LATEST");
        } else if (((String)this.descriptor.getOffset().get()).equals("EARLIEST") || ((String)this.descriptor.getOffset().get()).equals("LATEST")) {
            body.put("start", this.descriptor.getOffset().get());
        } else {
            body.put("resume_offset", this.descriptor.getOffset().get());
        }
        if (this.descriptor.getSubset().isPresent()) {
            body.put("subset", this.descriptor.getSubset().get());
        }
        if (this.descriptor.getFilters().isPresent()) {
            body.put("filters", this.descriptor.getFilters().get());
        }
        String json = GSON.toJson(body);
        return json.getBytes(StandardCharsets.UTF_8);
    }

    private String getAppKey() {
        return this.descriptor.getCreds().getAppKey();
    }

    private static final class Connection {
        private final ListenableFuture<Boolean> future;
        private final MobileEventStreamResponseHandler handler;

        public Connection(ListenableFuture<Boolean> future, MobileEventStreamResponseHandler handler) {
            this.future = future;
            this.handler = handler;
        }
    }
}

