/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.connect.client;

import com.google.common.base.Supplier;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.urbanairship.connect.client.model.GsonUtil;
import com.urbanairship.connect.client.model.responses.Event;
import com.urbanairship.connect.java8.Consumer;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class RawEventReceiver
implements Consumer<String>,
Supplier<String> {
    private static final Logger log = LogManager.getLogger(RawEventReceiver.class);
    private static final Gson gson = GsonUtil.getGson();
    private AtomicReference<String> lastOffset = new AtomicReference<String>("0");
    private final Consumer<Event> consumer;

    public RawEventReceiver(Consumer<Event> consumer) {
        this.consumer = consumer;
    }

    @Override
    public void accept(String event) {
        try {
            Event eventObj = (Event)gson.fromJson(event, Event.class);
            log.debug((Object)("Parsing event " + eventObj.getIdentifier()));
            this.lastOffset.set(eventObj.getOffset());
            this.consumer.accept(eventObj);
        }
        catch (JsonSyntaxException e) {
            log.warn((Object)("Error parsing  " + event), (Throwable)e);
        }
        catch (JsonParseException e) {
            log.warn((Object)("Error parsing " + event), (Throwable)e);
        }
    }

    public String get() {
        return this.lastOffset.get();
    }
}

