/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.connect.client;

import com.google.common.base.Optional;
import com.urbanairship.connect.client.Creds;
import com.urbanairship.connect.client.model.Subset;
import com.urbanairship.connect.client.model.filters.Filter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public final class StreamQueryDescriptor {
    private final Creds creds;
    private final Optional<String> offset;
    private final Optional<Set<Filter>> filters;
    private final Optional<Subset> subset;

    public static Builder newBuilder() {
        return new Builder();
    }

    private StreamQueryDescriptor(Creds creds, Optional<String> offset, Optional<Set<Filter>> filters, Optional<Subset> subset) {
        this.creds = creds;
        this.offset = offset;
        this.filters = filters;
        this.subset = subset;
    }

    public Creds getCreds() {
        return this.creds;
    }

    public Optional<String> getOffset() {
        return this.offset;
    }

    public Optional<Set<Filter>> getFilters() {
        return this.filters;
    }

    public Optional<Subset> getSubset() {
        return this.subset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamQueryDescriptor that = (StreamQueryDescriptor)o;
        return Objects.equals(this.creds, that.creds) && Objects.equals(this.offset, that.offset) && Objects.equals(this.filters, that.filters) && Objects.equals(this.subset, that.subset);
    }

    public int hashCode() {
        return Objects.hash(this.creds, this.offset, this.filters, this.subset);
    }

    public static final class Builder {
        private Creds creds;
        private String offset = null;
        private Set<Filter> filters = null;
        private Subset subset = null;

        private Builder() {
        }

        public Builder setCreds(Creds value) {
            this.creds = value;
            return this;
        }

        public Builder setOffset(String value) {
            this.offset = value;
            return this;
        }

        public Builder addFilter(Filter value) {
            return this.addFilters(value);
        }

        public Builder addFilters(Filter ... value) {
            return this.addFilters(new HashSet<Filter>(Arrays.asList(value)));
        }

        public Builder addFilters(Collection<Filter> value) {
            if (this.filters == null) {
                this.filters = new HashSet<Filter>();
            }
            this.filters.addAll(value);
            return this;
        }

        public Builder setSubset(Subset value) {
            this.subset = value;
            return this;
        }

        public StreamQueryDescriptor build() {
            return new StreamQueryDescriptor(this.creds, Optional.fromNullable((Object)this.offset), Optional.fromNullable(this.filters), Optional.fromNullable((Object)this.subset));
        }
    }
}

