/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.connect.client;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.urbanairship.connect.client.ConnectClientConfiguration;
import com.urbanairship.connect.client.Creds;
import com.urbanairship.connect.client.MobileEventStream;
import com.urbanairship.connect.client.StreamQueryDescriptor;
import com.urbanairship.connect.client.model.Subset;
import com.urbanairship.connect.client.offsets.OffsetManager;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class StreamUtils {
    private static final Logger log = LogManager.getLogger(StreamUtils.class);

    public static StreamQueryDescriptor buildNewDescriptor(StreamQueryDescriptor baseStreamQueryDescriptor, OffsetManager offsetManager) {
        Creds creds = baseStreamQueryDescriptor.getCreds();
        StreamQueryDescriptor.Builder builder = StreamQueryDescriptor.newBuilder();
        builder.setCreds(creds);
        if (baseStreamQueryDescriptor.getFilters().isPresent()) {
            builder.addFilters((Collection)baseStreamQueryDescriptor.getFilters().get());
        }
        if (baseStreamQueryDescriptor.getSubset().isPresent()) {
            builder.setSubset((Subset)baseStreamQueryDescriptor.getSubset().get());
        }
        if (offsetManager.getLastOffset().isPresent()) {
            builder.setOffset((String)offsetManager.getLastOffset().get());
        }
        return builder.build();
    }

    public static AsyncHttpClient buildHttpClient(ConnectClientConfiguration config) {
        AsyncHttpClientConfig clientConfig = new AsyncHttpClientConfig.Builder().setConnectTimeout(config.mesHttpConnectTimeout).setReadTimeout(config.mesHttpReadTimeout).setUserAgent("Connect Client").setRequestTimeout(-1).setAllowPoolingConnections(false).setAllowPoolingSslConnections(false).build();
        return new AsyncHttpClient(clientConfig);
    }

    public static boolean connectWithRetries(MobileEventStream stream, ConnectClientConfiguration config, String appKey) throws InterruptedException {
        int baseConnectionAttempts = 0;
        long backoff = config.mesReconnectBackoffTime;
        for (int connectionAttempts = baseConnectionAttempts; connectionAttempts < config.maxConnectionAttempts; ++connectionAttempts) {
            try {
                if (connectionAttempts > baseConnectionAttempts) {
                    Thread.sleep(backoff);
                }
                if ((backoff += backoff * (long)connectionAttempts) > (long)config.maxConnectionAttempts * config.mesReconnectBackoffTime) {
                    backoff = (long)config.maxConnectionAttempts * config.mesReconnectBackoffTime;
                }
                stream.connect(config.appStreamConnectTimeout, TimeUnit.MILLISECONDS);
                return true;
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Throwable throwable) {
                log.error((Object)("Error encountered while connecting to stream for app " + appKey), throwable);
                continue;
            }
        }
        log.error((Object)("Handler failed to reconnect after " + config.maxConnectionAttempts + " attempts, exiting."));
        return false;
    }
}

