/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.connect.client.consume;

import com.urbanairship.connect.java8.Consumer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;

public final class MobileEventStreamBodyConsumer
implements Consumer<byte[]> {
    private static final byte[] EMPTY = new byte[0];
    private final Consumer<String> eventHandler;
    private byte[] remaining = EMPTY;

    public MobileEventStreamBodyConsumer(Consumer<String> eventHandler) {
        this.eventHandler = eventHandler;
    }

    @Override
    public void accept(byte[] bodyContent) {
        byte[] available;
        if (this.remaining.length > 0) {
            int totalSize = this.remaining.length + bodyContent.length;
            available = new byte[totalSize];
            System.arraycopy(this.remaining, 0, available, 0, this.remaining.length);
            System.arraycopy(bodyContent, 0, available, this.remaining.length, bodyContent.length);
        } else {
            available = bodyContent;
        }
        ArrayList<Integer> newLineIndexes = new ArrayList<Integer>();
        for (int i = 0; i < available.length; ++i) {
            if (10 != available[i]) continue;
            newLineIndexes.add(i);
        }
        int rollingIdx = 0;
        for (Integer idx : newLineIndexes) {
            int lineBytesLength = idx - rollingIdx;
            if (lineBytesLength > 0) {
                String line = new String(available, rollingIdx, lineBytesLength, StandardCharsets.UTF_8);
                this.eventHandler.accept(line);
            }
            rollingIdx += lineBytesLength + 1;
        }
        byte[] newRemaining = EMPTY;
        if (rollingIdx < available.length) {
            int remainingLength = available.length - rollingIdx;
            newRemaining = new byte[remainingLength];
            System.arraycopy(available, rollingIdx, newRemaining, 0, remainingLength);
        }
        this.remaining = newRemaining;
    }
}

