/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.connect.client.consume;

import com.google.common.base.Optional;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.urbanairship.connect.client.consume.ConnectCallback;
import com.urbanairship.connect.client.consume.StatusAndHeaders;
import com.urbanairship.connect.java8.Consumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class MobileEventStreamResponseHandler
implements AsyncHandler<Boolean> {
    private final AtomicBoolean stop = new AtomicBoolean(false);
    private int statusCode;
    private String statusMessage;
    private final CountDownLatch consumeLatch = new CountDownLatch(1);
    private final Semaphore consumePermit = new Semaphore(1);
    private volatile boolean connected = false;
    private final Consumer<byte[]> receiver;
    private final ConnectCallback connectCallback;
    private final AtomicReference<Throwable> error = new AtomicReference<Object>(null);

    public MobileEventStreamResponseHandler(Consumer<byte[]> receiver, ConnectCallback connectCallback) {
        this.receiver = receiver;
        this.connectCallback = connectCallback;
    }

    public void onThrowable(Throwable t) {
        if (!this.connected) {
            this.connectCallback.error(t);
        }
        this.error.set(t);
        try {
            this.stop();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted stopping handler on error receipt!", e);
        }
    }

    public AsyncHandler.STATE onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
        this.statusCode = responseStatus.getStatusCode();
        this.statusMessage = responseStatus.getStatusText();
        return AsyncHandler.STATE.CONTINUE;
    }

    public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
        HashMap<String, List<String>> copied = new HashMap<String, List<String>>();
        for (Map.Entry entry : headers.getHeaders().entrySet()) {
            copied.put((String)entry.getKey(), new ArrayList((Collection)entry.getValue()));
        }
        StatusAndHeaders statusAndHeaders = new StatusAndHeaders(this.statusCode, this.statusMessage, copied);
        this.connected = true;
        this.connectCallback.connected(statusAndHeaders);
        return AsyncHandler.STATE.CONTINUE;
    }

    public void consumeBody() {
        this.consumeLatch.countDown();
    }

    public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
        this.consumeLatch.await();
        if (!this.consumePermit.tryAcquire()) {
            return AsyncHandler.STATE.ABORT;
        }
        try {
            this.receiver.accept(bodyPart.getBodyPartBytes());
        }
        finally {
            this.consumePermit.release();
        }
        return this.stop.get() ? AsyncHandler.STATE.ABORT : AsyncHandler.STATE.CONTINUE;
    }

    public Boolean onCompleted() throws Exception {
        return Boolean.TRUE;
    }

    public Optional<Throwable> getError() {
        return Optional.fromNullable((Object)this.error.get());
    }

    public void stop() throws InterruptedException {
        if (this.stop.compareAndSet(false, true)) {
            this.consumePermit.acquire();
            this.consumeLatch.countDown();
        }
    }
}

