/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.connect.client.consume;

import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public final class StatusAndHeaders {
    private final int statusCode;
    private final String statusMessage;
    private final Map<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);

    public StatusAndHeaders(int statusCode, String statusMessage, Map<String, List<String>> headers) {
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
        this.headers.putAll(headers);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatusAndHeaders that = (StatusAndHeaders)o;
        return Objects.equals(this.statusCode, that.statusCode) && Objects.equals(this.statusMessage, that.statusMessage) && Objects.equals(this.headers, that.headers);
    }

    public int hashCode() {
        return Objects.hash(this.statusCode, this.statusMessage, this.headers);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("statusCode", this.statusCode).add("statusMessage", (Object)this.statusMessage).add("headers", this.headers).toString();
    }
}

