/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.connect.client.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapterFactory;
import com.urbanairship.connect.client.model.OptionalTypeAdapterFactory;
import com.urbanairship.connect.client.model.filters.DeviceFilter;
import com.urbanairship.connect.client.model.filters.DeviceFilterSerializer;
import com.urbanairship.connect.client.model.responses.DateTimeAdapter;
import com.urbanairship.connect.client.model.responses.DeviceInfo;
import com.urbanairship.connect.client.model.responses.DeviceInfoAdapter;
import com.urbanairship.connect.client.model.responses.Event;
import com.urbanairship.connect.client.model.responses.EventAdapter;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import org.joda.time.DateTime;

public class GsonUtil {
    private static final JsonParser parser = new JsonParser();
    private static final Gson gson;

    public static JsonObject parseJSONfromBytes(byte[] bytes) {
        String byteString = new String(bytes, StandardCharsets.UTF_8);
        return parser.parse(byteString).getAsJsonObject();
    }

    public static byte[] serializeToJSONBytes(Object serializableObject, Type type) {
        return gson.toJson(serializableObject, type).toString().getBytes(StandardCharsets.UTF_8);
    }

    public static Gson getGson() {
        return gson;
    }

    public static JsonParser getParser() {
        return parser;
    }

    static {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(DeviceInfo.class, (Object)new DeviceInfoAdapter());
        builder.registerTypeAdapterFactory((TypeAdapterFactory)new OptionalTypeAdapterFactory());
        builder.registerTypeAdapter(Event.class, (Object)new EventAdapter());
        builder.registerTypeAdapter(DeviceFilter.class, (Object)new DeviceFilterSerializer());
        builder.registerTypeAdapter(DateTime.class, (Object)new DateTimeAdapter());
        gson = builder.create();
    }
}

