/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.connect.client.model;

import com.google.common.base.Optional;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class OptionalTypeAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (!Optional.class.equals((Object)type.getRawType())) {
            return null;
        }
        ParameterizedType parameterizedOptionalType = (ParameterizedType)type.getType();
        Type targetType = parameterizedOptionalType.getActualTypeArguments()[0];
        TypeAdapter targetTypeAdapter = gson.getAdapter(TypeToken.get((Type)targetType));
        return this.newOptionalAdapter(targetTypeAdapter);
    }

    private <E> TypeAdapter<Optional<E>> newOptionalAdapter(final TypeAdapter<E> elementAdapter) {
        return new TypeAdapter<Optional<E>>(){

            public void write(JsonWriter out, Optional<E> value) throws IOException {
                if (value.isPresent()) {
                    elementAdapter.write(out, value.get());
                } else {
                    out.nullValue();
                }
            }

            public Optional<E> read(JsonReader in) throws IOException {
                return Optional.fromNullable((Object)elementAdapter.read(in));
            }
        };
    }
}

