/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.connect.client.model;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

public class Subset {
    private final SubsetType type;
    private final Optional<Float> proportion;
    private final Optional<Integer> count;
    private final Optional<Integer> selection;

    public static Subset createSampleSubset(Float proportion) {
        return new Builder().setType(SubsetType.SAMPLE).setProportion(proportion).build();
    }

    public static Subset createPartitionSubset(Integer count, Integer selection) {
        return new Builder().setType(SubsetType.PARTITION).setCount(count).setSelection(selection).build();
    }

    private Subset(SubsetType type, Optional<Float> proportion, Optional<Integer> count, Optional<Integer> selection) {
        this.type = type;
        this.proportion = proportion;
        this.count = count;
        this.selection = selection;
    }

    public SubsetType getType() {
        return this.type;
    }

    public Optional<Float> getProportion() {
        return this.proportion;
    }

    public Optional<Integer> getCount() {
        return this.count;
    }

    public Optional<Integer> getSelection() {
        return this.selection;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Subset)) {
            return false;
        }
        Subset subset = (Subset)o;
        if (!this.count.equals(subset.count)) {
            return false;
        }
        if (!this.proportion.equals(subset.proportion)) {
            return false;
        }
        if (!this.selection.equals(subset.selection)) {
            return false;
        }
        return this.type == subset.type;
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.proportion.hashCode();
        result = 31 * result + this.count.hashCode();
        result = 31 * result + this.selection.hashCode();
        return result;
    }

    public String toString() {
        return "Subset{type=" + (Object)((Object)this.type) + ", proportion=" + this.proportion + ", count=" + this.count + ", selection=" + this.selection + '}';
    }

    private static final class Builder {
        private SubsetType type;
        private Float proportion = null;
        private Integer count = null;
        private Integer selection = null;

        private Builder() {
        }

        private Builder setType(SubsetType value) {
            this.type = value;
            return this;
        }

        private Builder setProportion(Float value) {
            this.proportion = value;
            return this;
        }

        private Builder setCount(Integer value) {
            this.count = value;
            return this;
        }

        private Builder setSelection(Integer value) {
            this.selection = value;
            return this;
        }

        private Subset build() {
            if (this.type == SubsetType.SAMPLE) {
                Preconditions.checkArgument((this.proportion != null ? 1 : 0) != 0, (Object)"If the subset is of type SAMPLE, proportion may not be null");
                Preconditions.checkArgument((this.selection == null && this.count == null ? 1 : 0) != 0, (Object)"If the subset is of type SAMPLE, selection and count must be null");
            } else if (this.type == SubsetType.PARTITION) {
                Preconditions.checkArgument((this.proportion == null ? 1 : 0) != 0, (Object)"If the subset is of type PARTITION, proportion must be null");
                Preconditions.checkArgument((this.selection != null && this.count != null ? 1 : 0) != 0, (Object)"If the subset is of type PARTITION, selection and count may not be null");
                Preconditions.checkArgument((this.selection < this.count ? 1 : 0) != 0, (Object)"Selection must be less than count");
            }
            return new Subset(this.type, Optional.fromNullable((Object)this.proportion), Optional.fromNullable((Object)this.count), Optional.fromNullable((Object)this.selection));
        }
    }

    private static enum SubsetType {
        SAMPLE,
        PARTITION;

    }
}

