/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.connect.client.model.filters;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import com.urbanairship.connect.client.model.DeviceFilterType;
import com.urbanairship.connect.client.model.EventType;
import com.urbanairship.connect.client.model.filters.DeviceFilter;
import com.urbanairship.connect.client.model.filters.NotificationFilter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class Filter {
    @SerializedName(value="device_types")
    private final Optional<Set<DeviceFilterType>> deviceTypes;
    private final Optional<Set<NotificationFilter>> notifications;
    private final Optional<Set<DeviceFilter>> devices;
    private final Optional<Set<EventType>> types;
    private final Optional<Integer> latency;

    public static Builder newBuilder() {
        return new Builder();
    }

    private Filter(Set<DeviceFilterType> deviceTypes, Set<NotificationFilter> notifications, Set<DeviceFilter> devices, Set<EventType> types, Integer latency) {
        this.deviceTypes = Optional.fromNullable(deviceTypes);
        this.notifications = Optional.fromNullable(notifications);
        this.devices = Optional.fromNullable(devices);
        this.types = Optional.fromNullable(types);
        this.latency = Optional.fromNullable((Object)latency);
    }

    public Optional<Set<DeviceFilterType>> getDeviceTypes() {
        return this.deviceTypes;
    }

    public Optional<Set<NotificationFilter>> getNotifications() {
        return this.notifications;
    }

    public Optional<Set<DeviceFilter>> getDevices() {
        return this.devices;
    }

    public Optional<Set<EventType>> getTypes() {
        return this.types;
    }

    public Optional<Integer> getLatency() {
        return this.latency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Filter)) {
            return false;
        }
        Filter filter = (Filter)o;
        if (!this.deviceTypes.equals(filter.deviceTypes)) {
            return false;
        }
        if (!this.devices.equals(filter.devices)) {
            return false;
        }
        if (!this.latency.equals(filter.latency)) {
            return false;
        }
        if (!this.notifications.equals(filter.notifications)) {
            return false;
        }
        return this.types.equals(filter.types);
    }

    public int hashCode() {
        int result = this.deviceTypes.hashCode();
        result = 31 * result + this.notifications.hashCode();
        result = 31 * result + this.devices.hashCode();
        result = 31 * result + this.types.hashCode();
        result = 31 * result + this.latency.hashCode();
        return result;
    }

    public String toString() {
        return "Filter{deviceTypes=" + this.deviceTypes + ", notifications=" + this.notifications + ", devices=" + this.devices + ", types=" + this.types + ", latency=" + this.latency + '}';
    }

    public static final class Builder {
        private Set<DeviceFilterType> deviceTypes = null;
        private Set<NotificationFilter> notifications = null;
        private Set<DeviceFilter> devices = null;
        private Set<EventType> types = null;
        private Integer latency = null;

        private Builder() {
        }

        public Builder addDeviceType(DeviceFilterType value) {
            return this.addDeviceTypes(value);
        }

        public Builder addDeviceTypes(DeviceFilterType ... value) {
            return this.addDeviceTypes(new HashSet<DeviceFilterType>(Arrays.asList(value)));
        }

        public Builder addDeviceTypes(Set<DeviceFilterType> value) {
            this.deviceTypes = value;
            return this;
        }

        public Builder addNotification(NotificationFilter value) {
            return this.addNotifications(value);
        }

        public Builder addNotifications(NotificationFilter ... value) {
            return this.addNotifications(new HashSet<NotificationFilter>(Arrays.asList(value)));
        }

        public Builder addNotifications(Set<NotificationFilter> value) {
            this.notifications = value;
            return this;
        }

        public Builder addDevice(DeviceFilter value) {
            return this.addDevices(value);
        }

        public Builder addDevices(DeviceFilter ... value) {
            return this.addDevices(new HashSet<DeviceFilter>(Arrays.asList(value)));
        }

        public Builder addDevices(Set<DeviceFilter> value) {
            this.devices = value;
            return this;
        }

        public Builder addType(EventType value) {
            return this.addTypes(value);
        }

        public Builder addTypes(EventType ... value) {
            return this.addTypes(new HashSet<EventType>(Arrays.asList(value)));
        }

        public Builder addTypes(Set<EventType> value) {
            this.types = value;
            return this;
        }

        public Builder setLatency(Integer value) {
            this.latency = value;
            return this;
        }

        public Filter build() {
            Preconditions.checkArgument((this.deviceTypes != null || this.notifications != null || this.devices != null || this.types != null || this.latency != null ? 1 : 0) != 0, (Object)"Cannot create an empty filter payload");
            return new Filter(this.deviceTypes, this.notifications, this.devices, this.types, this.latency);
        }
    }
}

