/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.connect.client.model.responses;

import com.google.common.base.Optional;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.urbanairship.connect.client.model.EventType;
import com.urbanairship.connect.client.model.GsonUtil;
import com.urbanairship.connect.client.model.responses.EventBody;

public class ControlEvent
implements EventBody {
    @SerializedName(value="push_id")
    private final String pushId;
    @SerializedName(value="group_id")
    private final Optional<String> groupId;

    @Override
    public EventType getType() {
        return EventType.CONTROL;
    }

    private ControlEvent() {
        this(null, (Optional<String>)Optional.absent());
    }

    public ControlEvent(String pushId, Optional<String> groupId) {
        this.pushId = pushId;
        this.groupId = groupId;
    }

    public Optional<String> getGroupId() {
        return this.groupId;
    }

    public String getPushId() {
        return this.pushId;
    }

    public static ControlEvent parseJSONfromBytes(byte[] bytes) {
        JsonObject jsonObject = GsonUtil.parseJSONfromBytes(bytes);
        return ControlEvent.parseJSON(jsonObject.toString());
    }

    public static ControlEvent parseJSON(String s) {
        return (ControlEvent)GsonUtil.getGson().fromJson(s, ControlEvent.class);
    }

    public byte[] serializeToJSONBytes() {
        return GsonUtil.serializeToJSONBytes(this, ControlEvent.class);
    }

    public String toString() {
        return "ControlEvent{pushId='" + this.pushId + '\'' + ", groupId=" + this.groupId + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ControlEvent that = (ControlEvent)o;
        if (!this.pushId.equals(that.pushId)) {
            return false;
        }
        return this.groupId.equals(that.groupId);
    }

    public int hashCode() {
        int result = this.pushId.hashCode();
        result = 31 * result + this.groupId.hashCode();
        return result;
    }
}

