/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.connect.client.model.responses;

import com.google.common.base.Optional;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.urbanairship.connect.client.model.EventType;
import com.urbanairship.connect.client.model.GsonUtil;
import com.urbanairship.connect.client.model.responses.AssociatedPush;
import com.urbanairship.connect.client.model.responses.EventBody;

public class CustomEvent
implements EventBody {
    private final String name;
    private final Optional<Double> value;
    @SerializedName(value="interaction_id")
    private final Optional<String> interactionId;
    @SerializedName(value="interaction_type")
    private final String interactionType;
    @SerializedName(value="last_delivered")
    private final Optional<AssociatedPush> lastDelivered;
    @SerializedName(value="triggering_push")
    private final Optional<AssociatedPush> triggeringPush;
    @SerializedName(value="sessionId")
    private final Optional<String> sessionId;

    private CustomEvent() {
        this(null, (Optional<Double>)Optional.absent(), (Optional<String>)Optional.absent(), null, (Optional<AssociatedPush>)Optional.absent(), (Optional<AssociatedPush>)Optional.absent(), (Optional<String>)Optional.absent());
    }

    public CustomEvent(String name, Optional<Double> value, Optional<String> interactionId, String interactionType, Optional<AssociatedPush> lastDelivered, Optional<AssociatedPush> triggeringPush, Optional<String> sessionId) {
        this.name = name;
        this.value = value;
        this.interactionId = interactionId;
        this.interactionType = interactionType;
        this.lastDelivered = lastDelivered;
        this.triggeringPush = triggeringPush;
        this.sessionId = sessionId;
    }

    public Optional<String> getSessionId() {
        return this.sessionId;
    }

    public String getName() {
        return this.name;
    }

    public Optional<Double> getValue() {
        return this.value;
    }

    public Optional<String> getInteractionId() {
        return this.interactionId;
    }

    public String getInteractionType() {
        return this.interactionType;
    }

    public Optional<AssociatedPush> getLastDelivered() {
        return this.lastDelivered;
    }

    public Optional<AssociatedPush> getTriggeringPush() {
        return this.triggeringPush;
    }

    public static CustomEvent parseJSONfromBytes(byte[] bytes) {
        JsonObject jsonObject = GsonUtil.parseJSONfromBytes(bytes);
        return CustomEvent.parseJSON(jsonObject.toString());
    }

    public static CustomEvent parseJSON(String json) {
        return (CustomEvent)GsonUtil.getGson().fromJson(json, CustomEvent.class);
    }

    public byte[] serializeToJSONBytes() {
        return GsonUtil.serializeToJSONBytes(this, CustomEvent.class);
    }

    public String toString() {
        return "CustomEvent{name='" + this.name + '\'' + ", value=" + this.value + ", interactionId=" + this.interactionId + ", interactionType='" + this.interactionType + '\'' + ", lastDelivered=" + this.lastDelivered + ", triggeringPush=" + this.triggeringPush + ", sessionId=" + this.sessionId + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomEvent that = (CustomEvent)o;
        if (this.getName() != null ? !this.getName().equals(that.getName()) : that.getName() != null) {
            return false;
        }
        if (this.getValue() != null ? !this.getValue().equals(that.getValue()) : that.getValue() != null) {
            return false;
        }
        if (this.getInteractionId() != null ? !this.getInteractionId().equals(that.getInteractionId()) : that.getInteractionId() != null) {
            return false;
        }
        if (this.getInteractionType() != null ? !this.getInteractionType().equals(that.getInteractionType()) : that.getInteractionType() != null) {
            return false;
        }
        if (this.getLastDelivered() != null ? !this.getLastDelivered().equals(that.getLastDelivered()) : that.getLastDelivered() != null) {
            return false;
        }
        if (this.getTriggeringPush() != null ? !this.getTriggeringPush().equals(that.getTriggeringPush()) : that.getTriggeringPush() != null) {
            return false;
        }
        return this.getSessionId() != null ? this.getSessionId().equals(that.getSessionId()) : that.getSessionId() == null;
    }

    public int hashCode() {
        int result = this.getName() != null ? this.getName().hashCode() : 0;
        result = 31 * result + (this.getValue() != null ? this.getValue().hashCode() : 0);
        result = 31 * result + (this.getInteractionId() != null ? this.getInteractionId().hashCode() : 0);
        result = 31 * result + (this.getInteractionType() != null ? this.getInteractionType().hashCode() : 0);
        result = 31 * result + (this.getLastDelivered() != null ? this.getLastDelivered().hashCode() : 0);
        result = 31 * result + (this.getTriggeringPush() != null ? this.getTriggeringPush().hashCode() : 0);
        result = 31 * result + (this.getSessionId() != null ? this.getSessionId().hashCode() : 0);
        return result;
    }

    @Override
    public EventType getType() {
        return EventType.CUSTOM;
    }
}

