/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.connect.client.model.responses;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class DateTimeAdapter
implements JsonDeserializer<DateTime>,
JsonSerializer<DateTime> {
    public JsonElement serialize(DateTime src, Type typeOfSrc, JsonSerializationContext context) {
        DateTimeFormatter fmt = ISODateTimeFormat.dateTime();
        return new JsonPrimitive(fmt.print((ReadableInstant)src));
    }

    public DateTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
        DateTimeFormatter fmt = ISODateTimeFormat.dateTimeParser().withZoneUTC();
        try {
            return fmt.parseDateTime(json.getAsString());
        }
        catch (Exception e) {
            return new DateTime((Object)json.getAsString()).withZone(DateTimeZone.UTC);
        }
    }
}

