/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.connect.client.model.responses;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.urbanairship.connect.client.model.DeviceFilterType;
import com.urbanairship.connect.client.model.GsonUtil;
import java.util.Map;

public class DeviceInfo {
    private final String channelId;
    private final DeviceFilterType platform;
    @SerializedName(value="named_user_id")
    private final Optional<String> namedUsedId;
    private final ImmutableMap<String, String> attributes;
    private final ImmutableMap<String, String> identifiers;

    private DeviceInfo(String channelId, DeviceFilterType platform, Optional<String> namedUsedId, ImmutableMap<String, String> attributes, ImmutableMap<String, String> identifiers) {
        this.channelId = channelId;
        this.platform = platform;
        this.namedUsedId = namedUsedId;
        this.attributes = attributes;
        this.identifiers = identifiers;
    }

    public Optional<String> getNamedUsedId() {
        return this.namedUsedId;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public DeviceFilterType getPlatform() {
        return this.platform;
    }

    public ImmutableMap<String, String> getAttributes() {
        return this.attributes;
    }

    public ImmutableMap<String, String> getIdentifiers() {
        return this.identifiers;
    }

    public static DeviceInfo parseJSONfromBytes(byte[] bytes) {
        JsonObject jsonObject = GsonUtil.parseJSONfromBytes(bytes);
        return DeviceInfo.parseJSON(jsonObject.toString());
    }

    public static DeviceInfo parseJSON(String json) {
        return (DeviceInfo)GsonUtil.getGson().fromJson(json, DeviceInfo.class);
    }

    public byte[] serializeToJSONBytes() {
        return GsonUtil.serializeToJSONBytes(this, DeviceInfo.class);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeviceInfo that = (DeviceInfo)o;
        if (!this.channelId.equals(that.channelId)) {
            return false;
        }
        if (this.platform != that.platform) {
            return false;
        }
        if (!this.namedUsedId.equals(that.namedUsedId)) {
            return false;
        }
        if (!this.attributes.equals(that.attributes)) {
            return false;
        }
        return this.identifiers.equals(that.identifiers);
    }

    public int hashCode() {
        int result = this.channelId.hashCode();
        result = 31 * result + this.platform.hashCode();
        result = 31 * result + this.namedUsedId.hashCode();
        result = 31 * result + this.attributes.hashCode();
        result = 31 * result + this.identifiers.hashCode();
        return result;
    }

    public String toString() {
        return "DeviceInfo{channelId='" + this.channelId + '\'' + ", platform=" + (Object)((Object)this.platform) + ", namedUsedId=" + this.namedUsedId + ", attributes=" + this.attributes + ", identifiers=" + this.identifiers + '}';
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Optional<String> namedUsedId = Optional.absent();
        private String channeId;
        private DeviceFilterType platform;
        private ImmutableMap.Builder<String, String> attributesBuilder = ImmutableMap.builder();
        private ImmutableMap.Builder<String, String> identifiersBuilder = ImmutableMap.builder();

        public Builder addAttribute(String key, String value) {
            this.attributesBuilder.put((Object)key, (Object)value);
            return this;
        }

        public Builder addAttributes(Map<String, String> map) {
            this.attributesBuilder.putAll(map);
            return this;
        }

        public Builder addIdentifiers(Map<String, String> map) {
            this.identifiersBuilder.putAll(map);
            return this;
        }

        public Builder addIdentifier(String key, String value) {
            this.identifiersBuilder.put((Object)key, (Object)value);
            return this;
        }

        public Builder setNamedUsedId(Optional<String> namedUsedId) {
            this.namedUsedId = namedUsedId;
            return this;
        }

        public Builder setChanneId(String channeId) {
            this.channeId = channeId;
            return this;
        }

        public Builder setPlatform(DeviceFilterType platform) {
            this.platform = platform;
            return this;
        }

        public DeviceInfo build() {
            Preconditions.checkNotNull((Object)((Object)this.platform), (Object)"Platform must be specified");
            Preconditions.checkNotNull((Object)this.channeId, (Object)"Channel ID must be specified");
            return new DeviceInfo(this.channeId, this.platform, this.namedUsedId, this.identifiersBuilder.build(), this.attributesBuilder.build());
        }
    }
}

