/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.connect.client.model.responses;

import com.google.common.base.Optional;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.urbanairship.connect.client.model.DeviceFilterType;
import com.urbanairship.connect.client.model.responses.DeviceInfo;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;

public class DeviceInfoAdapter
implements JsonDeserializer<DeviceInfo>,
JsonSerializer<DeviceInfo> {
    public DeviceInfo deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Optional platformOptional;
        JsonObject deviceJson = json.getAsJsonObject();
        DeviceInfo.Builder deviceInfoBuilder = DeviceInfo.newBuilder();
        ArrayList<Map.Entry> platforms = new ArrayList<Map.Entry>();
        for (Map.Entry entry : deviceJson.entrySet()) {
            Optional deviceType = Optional.fromNullable((Object)((Object)DeviceFilterType.getDeviceType((String)entry.getKey())));
            if (!deviceType.isPresent() || !((DeviceFilterType)((Object)deviceType.get())).isChannelType()) continue;
            platforms.add(entry);
        }
        if (platforms.size() > 1) {
            throw new JsonParseException("Multiple platforms defined, maximum of one platform allowed");
        }
        Optional parsedNamedUserId = Optional.fromNullable((Object)deviceJson.get(DeviceFilterType.NAMED_USER.getKey()));
        if (parsedNamedUserId.isPresent()) {
            Optional namedUserId = Optional.fromNullable((Object)((JsonElement)parsedNamedUserId.get()).getAsString());
            deviceInfoBuilder.setNamedUsedId((Optional<String>)namedUserId);
        }
        if (!(platformOptional = Optional.fromNullable(platforms.get(0))).isPresent()) {
            throw new JsonParseException("Unable to parse device platform from json");
        }
        deviceInfoBuilder.setChanneId(((JsonElement)((Map.Entry)platformOptional.get()).getValue()).getAsString());
        deviceInfoBuilder.setPlatform(DeviceFilterType.getDeviceType((String)((Map.Entry)platformOptional.get()).getKey()));
        if (deviceJson.has("attributes")) {
            for (Map.Entry entry : deviceJson.getAsJsonObject("attributes").entrySet()) {
                deviceInfoBuilder.addAttribute((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
            }
        }
        if (deviceJson.has("identifiers")) {
            for (Map.Entry entry : deviceJson.getAsJsonObject("identifiers").entrySet()) {
                deviceInfoBuilder.addIdentifier((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
            }
        }
        return deviceInfoBuilder.build();
    }

    public JsonElement serialize(DeviceInfo src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject deviceInfo = new JsonObject();
        String platformChannel = src.getPlatform().getKey();
        deviceInfo.addProperty(platformChannel, src.getChannelId());
        if (src.getNamedUsedId().isPresent()) {
            deviceInfo.addProperty(DeviceFilterType.NAMED_USER.getKey(), (String)src.getNamedUsedId().get());
        }
        if (!src.getAttributes().isEmpty()) {
            JsonObject attributes = new JsonObject();
            for (Map.Entry entry : src.getAttributes().entrySet()) {
                attributes.addProperty((String)entry.getKey(), (String)entry.getValue());
            }
            deviceInfo.add("attributes", (JsonElement)attributes);
        }
        if (!src.getIdentifiers().isEmpty()) {
            JsonObject identifiers = new JsonObject();
            for (Map.Entry entry : src.getIdentifiers().entrySet()) {
                identifiers.addProperty((String)entry.getKey(), (String)entry.getValue());
            }
            deviceInfo.add("identifiers", (JsonElement)identifiers);
        }
        return deviceInfo;
    }
}

