/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.connect.client.model.responses;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import com.urbanairship.connect.client.model.EventType;
import com.urbanairship.connect.client.model.responses.DeviceInfo;
import com.urbanairship.connect.client.model.responses.EventBody;
import org.joda.time.DateTime;

public class Event {
    public static final String DEVICE_INFO_KEY = "device";
    public static final String EVENT_BODY_KEY = "body";
    public static final String TYPE_KEY = "type";
    public static final String EVENT_ID_KEY = "id";
    public static final String OCCURRED_KEY = "occurred";
    public static final String PROCESSED_KEY = "processed";
    public static final String OFFSET_KEY = "offset";
    @SerializedName(value="id")
    private String identifier;
    @SerializedName(value="type")
    private EventType eventType;
    private DateTime occurred;
    private DateTime processed;
    private String offset;
    @SerializedName(value="device")
    private Optional<DeviceInfo> deviceInfo;
    @SerializedName(value="body")
    private EventBody eventBody;

    private Event() {
        this(null, null, null, null, null, (Optional<DeviceInfo>)Optional.absent(), null);
    }

    private Event(String identifier, EventType eventType, DateTime occurred, DateTime processed, String offset, Optional<DeviceInfo> deviceInfo, EventBody eventBody) {
        this.identifier = identifier;
        this.eventType = eventType;
        this.occurred = occurred;
        this.processed = processed;
        this.offset = offset;
        this.deviceInfo = deviceInfo;
        this.eventBody = eventBody;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public EventType getEventType() {
        return this.eventBody.getType();
    }

    public DateTime getOccurred() {
        return this.occurred;
    }

    public DateTime getProcessed() {
        return this.processed;
    }

    public String getOffset() {
        return this.offset;
    }

    public Optional<DeviceInfo> getDeviceInfo() {
        return this.deviceInfo;
    }

    public EventBody getEventBody() {
        return this.eventBody;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event event = (Event)o;
        if (this.offset != null ? !this.offset.equals(event.offset) : event.offset != null) {
            return false;
        }
        if (this.identifier != null ? !this.identifier.equals(event.identifier) : event.identifier != null) {
            return false;
        }
        if (this.eventType != event.eventType) {
            return false;
        }
        if (this.occurred != null ? !this.occurred.equals((Object)event.occurred) : event.occurred != null) {
            return false;
        }
        if (this.processed != null ? !this.processed.equals((Object)event.processed) : event.processed != null) {
            return false;
        }
        if (this.deviceInfo != null ? !this.deviceInfo.equals(event.deviceInfo) : event.deviceInfo != null) {
            return false;
        }
        return !(this.eventBody == null ? event.eventBody != null : !this.eventBody.equals(event.eventBody));
    }

    public int hashCode() {
        int result = this.identifier != null ? this.identifier.hashCode() : 0;
        result = 31 * result + (this.eventType != null ? this.eventType.hashCode() : 0);
        result = 31 * result + (this.occurred != null ? this.occurred.hashCode() : 0);
        result = 31 * result + (this.processed != null ? this.processed.hashCode() : 0);
        result = 31 * result + (this.deviceInfo != null ? this.deviceInfo.hashCode() : 0);
        result = 31 * result + (this.eventBody != null ? this.eventBody.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Event{identifier='" + this.identifier + '\'' + ", eventType=" + (Object)((Object)this.eventType) + ", occurred=" + this.occurred + ", processed=" + this.processed + ", offset='" + this.offset + '\'' + ", deviceInfo=" + this.deviceInfo + ", eventBody=" + this.eventBody + '}';
    }

    public static class Builder {
        private String identifier;
        private EventType eventType;
        private DateTime occurred;
        private DateTime processed;
        private String offset;
        private DeviceInfo deviceInfo;
        private EventBody eventBody;

        public Builder setIdentifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder setEventType(EventType eventType) {
            this.eventType = eventType;
            return this;
        }

        public Builder setOccurred(DateTime occurred) {
            this.occurred = occurred;
            return this;
        }

        public Builder setProcessed(DateTime processed) {
            this.processed = processed;
            return this;
        }

        public Builder setOffset(String offset) {
            this.offset = offset;
            return this;
        }

        public Builder setDeviceInfo(DeviceInfo deviceInfo) {
            this.deviceInfo = deviceInfo;
            return this;
        }

        public Builder setEventBody(EventBody eventBody) {
            this.eventBody = eventBody;
            return this;
        }

        public Event build() {
            Preconditions.checkNotNull((Object)this.identifier, (Object)"Missing event UUID");
            Preconditions.checkNotNull((Object)((Object)this.eventType), (Object)"Event type not set");
            Preconditions.checkNotNull((Object)this.occurred, (Object)"Missing occurred timestamp");
            Preconditions.checkNotNull((Object)this.processed, (Object)"Missing processed timestamp");
            Preconditions.checkNotNull((Object)this.eventBody, (Object)"Missing event body");
            Preconditions.checkNotNull((Object)this.offset, (Object)"Missing stream offset");
            return new Event(this.identifier, this.eventType, this.occurred, this.processed, this.offset, Optional.fromNullable((Object)this.deviceInfo), this.eventBody);
        }
    }
}

