/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.connect.client.model.responses;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.urbanairship.connect.client.model.EventType;
import com.urbanairship.connect.client.model.GsonUtil;
import com.urbanairship.connect.client.model.responses.CloseEvent;
import com.urbanairship.connect.client.model.responses.ControlEvent;
import com.urbanairship.connect.client.model.responses.CustomEvent;
import com.urbanairship.connect.client.model.responses.DeviceInfo;
import com.urbanairship.connect.client.model.responses.Event;
import com.urbanairship.connect.client.model.responses.EventBody;
import com.urbanairship.connect.client.model.responses.FirstOpenEvent;
import com.urbanairship.connect.client.model.responses.InAppMessageDisplayEvent;
import com.urbanairship.connect.client.model.responses.InAppMessageExpirationEvent;
import com.urbanairship.connect.client.model.responses.InAppMessageResolutionEvent;
import com.urbanairship.connect.client.model.responses.LocationEvent;
import com.urbanairship.connect.client.model.responses.OpenEvent;
import com.urbanairship.connect.client.model.responses.PushBody;
import com.urbanairship.connect.client.model.responses.RichDeleteEvent;
import com.urbanairship.connect.client.model.responses.RichDeliveryEvent;
import com.urbanairship.connect.client.model.responses.RichReadEvent;
import com.urbanairship.connect.client.model.responses.ScreenViewedEvent;
import com.urbanairship.connect.client.model.responses.SendEvent;
import com.urbanairship.connect.client.model.responses.TagChange;
import com.urbanairship.connect.client.model.responses.UninstallEvent;
import com.urbanairship.connect.client.model.responses.region.RegionEvent;
import java.lang.reflect.Type;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class EventAdapter
implements JsonDeserializer<Event> {
    private static final ImmutableBiMap<EventType, Type> typeMap = ImmutableBiMap.builder().put((Object)EventType.CLOSE, CloseEvent.class).put((Object)EventType.CUSTOM, CustomEvent.class).put((Object)EventType.LOCATION, LocationEvent.class).put((Object)EventType.OPEN, OpenEvent.class).put((Object)EventType.SEND, SendEvent.class).put((Object)EventType.TAG_CHANGE, TagChange.class).put((Object)EventType.UNINSTALL, UninstallEvent.class).put((Object)EventType.FIRST_OPEN, FirstOpenEvent.class).put((Object)EventType.REGION, RegionEvent.class).put((Object)EventType.RICH_READ, RichReadEvent.class).put((Object)EventType.RICH_DELETE, RichDeleteEvent.class).put((Object)EventType.RICH_DELIVERY, RichDeliveryEvent.class).put((Object)EventType.PUSH_BODY, PushBody.class).put((Object)EventType.IN_APP_MESSAGE_DISPLAY, InAppMessageDisplayEvent.class).put((Object)EventType.IN_APP_MESSAGE_EXPIRATION, InAppMessageExpirationEvent.class).put((Object)EventType.IN_APP_MESSAGE_RESOLUTION, InAppMessageResolutionEvent.class).put((Object)EventType.CONTROL, ControlEvent.class).put((Object)EventType.SCREEN_VIEWED, ScreenViewedEvent.class).build();
    private static final ImmutableList<EventType> emptyEventBodyTypes = ImmutableList.builder().add((Object)EventType.UNINSTALL).add((Object)EventType.FIRST_OPEN).build();

    public Event deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        EventBody eventBody;
        EventType eventType;
        JsonObject eventJson = json.getAsJsonObject();
        Event.Builder eventBuilder = Event.newBuilder();
        JsonElement eventId = eventJson.get("id");
        if (eventId == null || StringUtils.isEmpty((CharSequence)eventId.getAsString())) {
            throw new JsonParseException("Unable to parse event with missing identifier");
        }
        eventBuilder.setIdentifier(eventId.getAsString());
        JsonElement offset = eventJson.get("offset");
        if (offset == null) {
            throw new JsonParseException("Unable to parse event with missing offset");
        }
        eventBuilder.setOffset(offset.getAsString());
        JsonElement type = eventJson.get("type");
        if (type == null || StringUtils.isEmpty((CharSequence)type.getAsString())) {
            throw new JsonParseException("Unable to parse event with missing type");
        }
        try {
            eventType = EventType.valueOf(type.getAsString());
            if (!typeMap.containsKey((Object)eventType)) {
                throw new JsonParseException(String.format("Unable to create event of type: %s", type.getAsString()));
            }
        }
        catch (IllegalArgumentException e) {
            throw new JsonParseException(String.format("Unable to create event of type: %s", type.getAsString()), (Throwable)e);
        }
        eventBuilder.setEventType(eventType);
        JsonElement deviceInfo = eventJson.get("device");
        if (deviceInfo != null) {
            eventBuilder.setDeviceInfo(DeviceInfo.parseJSON(deviceInfo.toString()));
        }
        if (emptyEventBodyTypes.contains((Object)eventType)) {
            eventBody = (EventBody)GsonUtil.getGson().fromJson("{}", (Type)typeMap.get((Object)eventType));
        } else {
            JsonElement eventBodyJson = eventJson.get("body");
            if (eventBodyJson == null) {
                throw new JsonParseException("Unable to parse event with missing event body");
            }
            eventBody = (EventBody)GsonUtil.getGson().fromJson(eventBodyJson.toString(), (Type)typeMap.get((Object)eventType));
        }
        eventBuilder.setEventBody(eventBody);
        JsonElement occurredJson = eventJson.get("occurred");
        if (occurredJson == null) {
            throw new JsonParseException("Unable to parse event with missing occurred field");
        }
        JsonElement processedJson = eventJson.get("processed");
        if (processedJson == null) {
            throw new JsonParseException("Unable to parse event with missing processed field");
        }
        DateTimeFormatter fmt = ISODateTimeFormat.dateTimeParser().withZoneUTC();
        DateTime occurred = fmt.parseDateTime(occurredJson.getAsString());
        DateTime processed = fmt.parseDateTime(processedJson.getAsString());
        eventBuilder.setOccurred(occurred);
        eventBuilder.setProcessed(processed);
        return eventBuilder.build();
    }
}

