/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.connect.client.model.responses;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.urbanairship.connect.client.model.EventType;
import com.urbanairship.connect.client.model.GsonUtil;
import com.urbanairship.connect.client.model.responses.AssociatedPush;
import com.urbanairship.connect.client.model.responses.EventBody;

public class InAppMessageDisplayEvent
implements EventBody {
    @SerializedName(value="push_id")
    private final String pushId;
    @SerializedName(value="group_id")
    private final Optional<String> groupId;
    @SerializedName(value="variant_id")
    private final Optional<Integer> variantId;
    @SerializedName(value="triggering_push")
    private final Optional<AssociatedPush> triggeringPush;
    @SerializedName(value="session_id")
    private final Optional<String> sessionId;

    private InAppMessageDisplayEvent() {
        this(null, (Optional<String>)Optional.absent(), (Optional<Integer>)Optional.absent(), (Optional<AssociatedPush>)Optional.absent(), (Optional<String>)Optional.absent());
    }

    public InAppMessageDisplayEvent(String pushId, Optional<String> groupId, Optional<Integer> variantId, Optional<AssociatedPush> triggeringPush, Optional<String> sessionId) {
        this.pushId = pushId;
        this.groupId = groupId;
        this.variantId = variantId;
        this.triggeringPush = triggeringPush;
        this.sessionId = sessionId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<String> getSessionId() {
        return this.sessionId;
    }

    public String getPushId() {
        return this.pushId;
    }

    public Optional<String> getGroupId() {
        return this.groupId;
    }

    public Optional<Integer> getVariantId() {
        return this.variantId;
    }

    public Optional<AssociatedPush> getTriggeringPush() {
        return this.triggeringPush;
    }

    @Override
    public EventType getType() {
        return EventType.IN_APP_MESSAGE_DISPLAY;
    }

    public static InAppMessageDisplayEvent parseJSONfromBytes(byte[] bytes) {
        JsonObject jsonObject = GsonUtil.parseJSONfromBytes(bytes);
        return InAppMessageDisplayEvent.parseJSON(jsonObject.toString());
    }

    public static InAppMessageDisplayEvent parseJSON(String json) {
        return (InAppMessageDisplayEvent)GsonUtil.getGson().fromJson(json, InAppMessageDisplayEvent.class);
    }

    public byte[] serializeToJSONBytes() {
        return GsonUtil.serializeToJSONBytes(this, InAppMessageDisplayEvent.class);
    }

    public String toString() {
        return "InAppMessageDisplayEvent{pushId='" + this.pushId + '\'' + ", groupId=" + this.groupId + ", variantId=" + this.variantId + ", triggeringPush=" + this.triggeringPush + ", sessionId=" + this.sessionId + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InAppMessageDisplayEvent that = (InAppMessageDisplayEvent)o;
        if (this.getPushId() != null ? !this.getPushId().equals(that.getPushId()) : that.getPushId() != null) {
            return false;
        }
        if (this.getGroupId() != null ? !this.getGroupId().equals(that.getGroupId()) : that.getGroupId() != null) {
            return false;
        }
        if (this.getVariantId() != null ? !this.getVariantId().equals(that.getVariantId()) : that.getVariantId() != null) {
            return false;
        }
        if (this.getTriggeringPush() != null ? !this.getTriggeringPush().equals(that.getTriggeringPush()) : that.getTriggeringPush() != null) {
            return false;
        }
        return this.getSessionId() != null ? this.getSessionId().equals(that.getSessionId()) : that.getSessionId() == null;
    }

    public int hashCode() {
        int result = this.getPushId() != null ? this.getPushId().hashCode() : 0;
        result = 31 * result + (this.getGroupId() != null ? this.getGroupId().hashCode() : 0);
        result = 31 * result + (this.getVariantId() != null ? this.getVariantId().hashCode() : 0);
        result = 31 * result + (this.getTriggeringPush() != null ? this.getTriggeringPush().hashCode() : 0);
        result = 31 * result + (this.getSessionId() != null ? this.getSessionId().hashCode() : 0);
        return result;
    }

    public static class Builder {
        private String pushId;
        private Optional<String> groupId = Optional.absent();
        private Optional<Integer> variantId = Optional.absent();
        private Optional<AssociatedPush> triggeringPush = Optional.absent();
        private Optional<String> sessionId = Optional.absent();

        public Builder setPushId(String pushId) {
            this.pushId = pushId;
            return this;
        }

        public Builder setGroupId(String groupId) {
            this.groupId = Optional.of((Object)groupId);
            return this;
        }

        public Builder setVariantId(int variantId) {
            this.variantId = Optional.of((Object)variantId);
            return this;
        }

        public Builder setTriggeringPush(AssociatedPush triggeringPush) {
            this.triggeringPush = Optional.of((Object)triggeringPush);
            return this;
        }

        public Builder setSessionId(String sessionId) {
            this.sessionId = Optional.of((Object)sessionId);
            return this;
        }

        public InAppMessageDisplayEvent build() {
            Preconditions.checkNotNull((Object)this.pushId);
            return new InAppMessageDisplayEvent(this.pushId, this.groupId, this.variantId, this.triggeringPush, this.sessionId);
        }
    }
}

