/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.connect.client.model.responses;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.urbanairship.connect.client.model.EventType;
import com.urbanairship.connect.client.model.GsonUtil;
import com.urbanairship.connect.client.model.responses.AssociatedPush;
import com.urbanairship.connect.client.model.responses.EventBody;
import org.joda.time.DateTime;

public class InAppMessageExpirationEvent
implements EventBody {
    public static final String REPLACED = "REPLACED";
    public static final String EXPIRED = "EXPIRED";
    public static final String ALREADY_DISPLAYED = "ALREADY_DISPLAYED";
    public static final ImmutableSet<String> VALID_TYPES = ImmutableSet.of((Object)"REPLACED", (Object)"EXPIRED", (Object)"ALREADY_DISPLAYED");
    @SerializedName(value="push_id")
    private final String pushId;
    @SerializedName(value="group_id")
    private final Optional<String> groupId;
    @SerializedName(value="variant_id")
    private final Optional<Integer> variantId;
    @SerializedName(value="time_sent")
    private final Optional<DateTime> timeSent;
    @SerializedName(value="triggering_push")
    private final Optional<AssociatedPush> triggeringPush;
    private final String type;
    @SerializedName(value="time_expired")
    private final Optional<DateTime> timeExpired;
    @SerializedName(value="replacing_push")
    private final Optional<AssociatedPush> replacingPush;
    @SerializedName(value="session_id")
    private final Optional<String> sessionId;

    public static InAppMessageExpirationEvent parseJSONfromBytes(byte[] bytes) {
        JsonObject jsonObject = GsonUtil.parseJSONfromBytes(bytes);
        return InAppMessageExpirationEvent.parseJSON(jsonObject.toString());
    }

    public static InAppMessageExpirationEvent parseJSON(String json) {
        return (InAppMessageExpirationEvent)GsonUtil.getGson().fromJson(json, InAppMessageExpirationEvent.class);
    }

    public byte[] serializeToJSONBytes() {
        return GsonUtil.serializeToJSONBytes(this, InAppMessageExpirationEvent.class);
    }

    public InAppMessageExpirationEvent(String pushId, Optional<String> groupId, Optional<Integer> variantId, Optional<DateTime> timeSent, Optional<AssociatedPush> triggeringPush, String type, Optional<DateTime> timeExpired, Optional<AssociatedPush> replacingPush, Optional<String> sessionId) {
        this.pushId = pushId;
        this.groupId = groupId;
        this.variantId = variantId;
        this.timeSent = timeSent;
        this.triggeringPush = triggeringPush;
        this.type = type;
        this.timeExpired = timeExpired;
        this.replacingPush = replacingPush;
        this.sessionId = sessionId;
    }

    private InAppMessageExpirationEvent() {
        this(null, (Optional<String>)Optional.absent(), (Optional<Integer>)Optional.absent(), (Optional<DateTime>)Optional.absent(), (Optional<AssociatedPush>)Optional.absent(), null, (Optional<DateTime>)Optional.absent(), (Optional<AssociatedPush>)Optional.absent(), (Optional<String>)Optional.absent());
    }

    @Override
    public EventType getType() {
        return EventType.IN_APP_MESSAGE_EXPIRATION;
    }

    public String getExpirationType() {
        return this.type;
    }

    public String getPushId() {
        return this.pushId;
    }

    public Optional<String> getGroupId() {
        return this.groupId;
    }

    public Optional<Integer> getVariantId() {
        return this.variantId;
    }

    public Optional<DateTime> getTimeSent() {
        return this.timeSent;
    }

    public Optional<AssociatedPush> getTriggeringPush() {
        return this.triggeringPush;
    }

    public Optional<DateTime> getTimeExpired() {
        return this.timeExpired;
    }

    public Optional<AssociatedPush> getReplacingPush() {
        return this.replacingPush;
    }

    public Optional<String> getSessionId() {
        return this.sessionId;
    }

    public String toString() {
        return "InAppMessageExpirationEvent{pushId='" + this.pushId + '\'' + ", groupId=" + this.groupId + ", variantId=" + this.variantId + ", timeSent=" + this.timeSent + ", triggeringPush=" + this.triggeringPush + ", type='" + this.type + '\'' + ", timeExpired=" + this.timeExpired + ", replacingPush=" + this.replacingPush + ", sessionId=" + this.sessionId + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InAppMessageExpirationEvent that = (InAppMessageExpirationEvent)o;
        if (this.getPushId() != null ? !this.getPushId().equals(that.getPushId()) : that.getPushId() != null) {
            return false;
        }
        if (this.getGroupId() != null ? !this.getGroupId().equals(that.getGroupId()) : that.getGroupId() != null) {
            return false;
        }
        if (this.getVariantId() != null ? !this.getVariantId().equals(that.getVariantId()) : that.getVariantId() != null) {
            return false;
        }
        if (this.getTimeSent() != null ? !this.getTimeSent().equals(that.getTimeSent()) : that.getTimeSent() != null) {
            return false;
        }
        if (this.getTriggeringPush() != null ? !this.getTriggeringPush().equals(that.getTriggeringPush()) : that.getTriggeringPush() != null) {
            return false;
        }
        if (this.getType() != null ? !this.getType().equals((Object)that.getType()) : that.getType() != null) {
            return false;
        }
        if (this.getTimeExpired() != null ? !this.getTimeExpired().equals(that.getTimeExpired()) : that.getTimeExpired() != null) {
            return false;
        }
        if (this.getReplacingPush() != null ? !this.getReplacingPush().equals(that.getReplacingPush()) : that.getReplacingPush() != null) {
            return false;
        }
        return this.getSessionId() != null ? this.getSessionId().equals(that.getSessionId()) : that.getSessionId() == null;
    }

    public int hashCode() {
        int result = this.getPushId() != null ? this.getPushId().hashCode() : 0;
        result = 31 * result + (this.getGroupId() != null ? this.getGroupId().hashCode() : 0);
        result = 31 * result + (this.getVariantId() != null ? this.getVariantId().hashCode() : 0);
        result = 31 * result + (this.getTimeSent() != null ? this.getTimeSent().hashCode() : 0);
        result = 31 * result + (this.getTriggeringPush() != null ? this.getTriggeringPush().hashCode() : 0);
        result = 31 * result + (this.getType() != null ? this.getType().hashCode() : 0);
        result = 31 * result + (this.getTimeExpired() != null ? this.getTimeExpired().hashCode() : 0);
        result = 31 * result + (this.getReplacingPush() != null ? this.getReplacingPush().hashCode() : 0);
        result = 31 * result + (this.getSessionId() != null ? this.getSessionId().hashCode() : 0);
        return result;
    }

    public static class Builder {
        private String pushId;
        private Optional<String> groupId = Optional.absent();
        private Optional<Integer> variantId = Optional.absent();
        private Optional<DateTime> timeSent = Optional.absent();
        private Optional<AssociatedPush> triggeringPush = Optional.absent();
        private String type;
        private Optional<DateTime> timeExpired = Optional.absent();
        private Optional<AssociatedPush> replacingPush = Optional.absent();
        private Optional<String> sessionId = Optional.absent();

        public Builder setPushId(String pushId) {
            this.pushId = pushId;
            return this;
        }

        public Builder setGroupId(String groupId) {
            this.groupId = Optional.of((Object)groupId);
            return this;
        }

        public Builder setVariantId(int variantId) {
            this.variantId = Optional.of((Object)variantId);
            return this;
        }

        public Builder setTimeSent(DateTime timeSent) {
            this.timeSent = Optional.of((Object)timeSent);
            return this;
        }

        public Builder setTriggeringPush(AssociatedPush triggeringPush) {
            this.triggeringPush = Optional.of((Object)triggeringPush);
            return this;
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public Builder setTimeExpired(DateTime timeExpired) {
            this.timeExpired = Optional.of((Object)timeExpired);
            return this;
        }

        public Builder setReplacingPush(AssociatedPush replacingPush) {
            this.replacingPush = Optional.of((Object)replacingPush);
            return this;
        }

        public Builder setSessionId(String sessionId) {
            this.sessionId = Optional.of((Object)sessionId);
            return this;
        }

        public InAppMessageExpirationEvent build() {
            Preconditions.checkNotNull((Object)this.pushId);
            Preconditions.checkNotNull((Object)this.type);
            Preconditions.checkState((boolean)VALID_TYPES.contains((Object)this.type));
            return new InAppMessageExpirationEvent(this.pushId, this.groupId, this.variantId, this.timeSent, this.triggeringPush, this.type, this.timeExpired, this.replacingPush, this.sessionId);
        }
    }
}

