/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.connect.client.model.responses;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.urbanairship.connect.client.model.EventType;
import com.urbanairship.connect.client.model.GsonUtil;
import com.urbanairship.connect.client.model.responses.AssociatedPush;
import com.urbanairship.connect.client.model.responses.EventBody;
import org.joda.time.DateTime;

public class InAppMessageResolutionEvent
implements EventBody {
    public static final String BUTTON_CLICK = "BUTTON_CLICK";
    public static final String MESSAGE_CLICK = "MESSAGE_CLICK";
    public static final String USER_DISMISSED = "USER_DISMISSED";
    public static final String TIMED_OUT = "TIMED_OUT";
    public static final ImmutableSet<String> VALID_TYPES = ImmutableSet.of((Object)"BUTTON_CLICK", (Object)"MESSAGE_CLICK", (Object)"USER_DISMISSED", (Object)"TIMED_OUT");
    @SerializedName(value="push_id")
    private final String pushId;
    @SerializedName(value="group_id")
    private final Optional<String> groupId;
    @SerializedName(value="variant_id")
    private final Optional<Integer> variantId;
    @SerializedName(value="time_sent")
    private final Optional<DateTime> timeSent;
    @SerializedName(value="triggering_push")
    private final Optional<AssociatedPush> triggeringPush;
    private final String type;
    @SerializedName(value="button_id")
    private final Optional<String> buttonId;
    @SerializedName(value="button_group")
    private final Optional<String> buttonGroup;
    @SerializedName(value="button_description")
    private final Optional<String> buttonDescription;
    @SerializedName(value="session_id")
    private final Optional<String> sessionId;
    private final long duration;

    public InAppMessageResolutionEvent(String pushId, Optional<String> groupId, Optional<Integer> variantId, Optional<DateTime> timeSent, Optional<AssociatedPush> triggeringPush, String type, Optional<String> buttonId, Optional<String> buttonGroup, Optional<String> buttonDescription, Optional<String> sessionId, long duration) {
        this.pushId = pushId;
        this.groupId = groupId;
        this.variantId = variantId;
        this.timeSent = timeSent;
        this.triggeringPush = triggeringPush;
        this.type = type;
        this.buttonId = buttonId;
        this.buttonGroup = buttonGroup;
        this.buttonDescription = buttonDescription;
        this.sessionId = sessionId;
        this.duration = duration;
    }

    private InAppMessageResolutionEvent() {
        this(null, (Optional<String>)Optional.absent(), (Optional<Integer>)Optional.absent(), (Optional<DateTime>)Optional.absent(), (Optional<AssociatedPush>)Optional.absent(), null, (Optional<String>)Optional.absent(), (Optional<String>)Optional.absent(), (Optional<String>)Optional.absent(), (Optional<String>)Optional.absent(), 0L);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static InAppMessageResolutionEvent parseJSONfromBytes(byte[] bytes) {
        JsonObject jsonObject = GsonUtil.parseJSONfromBytes(bytes);
        return InAppMessageResolutionEvent.parseJSON(jsonObject.toString());
    }

    public static InAppMessageResolutionEvent parseJSON(String json) {
        return (InAppMessageResolutionEvent)GsonUtil.getGson().fromJson(json, InAppMessageResolutionEvent.class);
    }

    public byte[] serializeToJSONBytes() {
        return GsonUtil.serializeToJSONBytes(this, InAppMessageResolutionEvent.class);
    }

    public String toString() {
        return "InAppMessageResolutionEvent{pushId='" + this.pushId + '\'' + ", groupId=" + this.groupId + ", variantId=" + this.variantId + ", timeSent=" + this.timeSent + ", triggeringPush=" + this.triggeringPush + ", type='" + this.type + '\'' + ", buttonId=" + this.buttonId + ", buttonGroup=" + this.buttonGroup + ", buttonDescription=" + this.buttonDescription + ", sessionId=" + this.sessionId + ", duration=" + this.duration + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InAppMessageResolutionEvent that = (InAppMessageResolutionEvent)o;
        if (this.getDuration() != that.getDuration()) {
            return false;
        }
        if (this.getPushId() != null ? !this.getPushId().equals(that.getPushId()) : that.getPushId() != null) {
            return false;
        }
        if (this.getGroupId() != null ? !this.getGroupId().equals(that.getGroupId()) : that.getGroupId() != null) {
            return false;
        }
        if (this.getVariantId() != null ? !this.getVariantId().equals(that.getVariantId()) : that.getVariantId() != null) {
            return false;
        }
        if (this.getTimeSent() != null ? !this.getTimeSent().equals(that.getTimeSent()) : that.getTimeSent() != null) {
            return false;
        }
        if (this.getTriggeringPush() != null ? !this.getTriggeringPush().equals(that.getTriggeringPush()) : that.getTriggeringPush() != null) {
            return false;
        }
        if (this.getType() != null ? !this.getType().equals((Object)that.getType()) : that.getType() != null) {
            return false;
        }
        if (this.getButtonId() != null ? !this.getButtonId().equals(that.getButtonId()) : that.getButtonId() != null) {
            return false;
        }
        if (this.getButtonGroup() != null ? !this.getButtonGroup().equals(that.getButtonGroup()) : that.getButtonGroup() != null) {
            return false;
        }
        if (this.getButtonDescription() != null ? !this.getButtonDescription().equals(that.getButtonDescription()) : that.getButtonDescription() != null) {
            return false;
        }
        return this.getSessionId() != null ? this.getSessionId().equals(that.getSessionId()) : that.getSessionId() == null;
    }

    public int hashCode() {
        int result = this.getPushId() != null ? this.getPushId().hashCode() : 0;
        result = 31 * result + (this.getGroupId() != null ? this.getGroupId().hashCode() : 0);
        result = 31 * result + (this.getVariantId() != null ? this.getVariantId().hashCode() : 0);
        result = 31 * result + (this.getTimeSent() != null ? this.getTimeSent().hashCode() : 0);
        result = 31 * result + (this.getTriggeringPush() != null ? this.getTriggeringPush().hashCode() : 0);
        result = 31 * result + (this.getType() != null ? this.getType().hashCode() : 0);
        result = 31 * result + (this.getButtonId() != null ? this.getButtonId().hashCode() : 0);
        result = 31 * result + (this.getButtonGroup() != null ? this.getButtonGroup().hashCode() : 0);
        result = 31 * result + (this.getButtonDescription() != null ? this.getButtonDescription().hashCode() : 0);
        result = 31 * result + (this.getSessionId() != null ? this.getSessionId().hashCode() : 0);
        result = 31 * result + (int)(this.getDuration() ^ this.getDuration() >>> 32);
        return result;
    }

    public Optional<String> getButtonId() {
        return this.buttonId;
    }

    public Optional<String> getButtonGroup() {
        return this.buttonGroup;
    }

    public Optional<String> getButtonDescription() {
        return this.buttonDescription;
    }

    public String getResolutionType() {
        return this.type;
    }

    public String getPushId() {
        return this.pushId;
    }

    public Optional<String> getGroupId() {
        return this.groupId;
    }

    public Optional<Integer> getVariantId() {
        return this.variantId;
    }

    public Optional<DateTime> getTimeSent() {
        return this.timeSent;
    }

    public Optional<AssociatedPush> getTriggeringPush() {
        return this.triggeringPush;
    }

    public long getDuration() {
        return this.duration;
    }

    public Optional<String> getSessionId() {
        return this.sessionId;
    }

    @Override
    public EventType getType() {
        return EventType.IN_APP_MESSAGE_RESOLUTION;
    }

    public static class Builder {
        private String pushId;
        private Optional<String> groupId = Optional.absent();
        private Optional<Integer> variantId = Optional.absent();
        private Optional<DateTime> timeSent = Optional.absent();
        private Optional<AssociatedPush> triggeringPush = Optional.absent();
        private String type;
        private long duration;
        private Optional<String> buttonId = Optional.absent();
        private Optional<String> buttonGroup = Optional.absent();
        private Optional<String> buttonDescription = Optional.absent();
        private Optional<String> sessionId = Optional.absent();

        public Builder setPushId(String pushId) {
            this.pushId = pushId;
            return this;
        }

        public Builder setGroupId(String groupId) {
            this.groupId = Optional.of((Object)groupId);
            return this;
        }

        public Builder setVariantId(Integer variantId) {
            this.variantId = Optional.of((Object)variantId);
            return this;
        }

        public Builder setTimeSent(DateTime timeSent) {
            this.timeSent = Optional.of((Object)timeSent);
            return this;
        }

        public Builder setTriggeringPush(AssociatedPush triggeringPush) {
            this.triggeringPush = Optional.of((Object)triggeringPush);
            return this;
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public Builder setDuration(long duration) {
            this.duration = duration;
            return this;
        }

        public Builder setSessionId(String sessionId) {
            this.sessionId = Optional.of((Object)sessionId);
            return this;
        }

        public InAppMessageResolutionEvent build() {
            Preconditions.checkNotNull((Object)this.pushId, (Object)"Must give a a pushId");
            Preconditions.checkNotNull((Object)this.type, (Object)"Must give a type");
            Preconditions.checkNotNull((Object)this.duration, (Object)"Must give a duration");
            Preconditions.checkState((boolean)VALID_TYPES.contains((Object)this.type));
            return new InAppMessageResolutionEvent(this.pushId, this.groupId, this.variantId, this.timeSent, this.triggeringPush, this.type, this.buttonId, this.buttonGroup, this.buttonDescription, this.sessionId, this.duration);
        }
    }
}

