/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.connect.client.model.responses;

import com.google.common.base.Optional;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.urbanairship.connect.client.model.EventType;
import com.urbanairship.connect.client.model.GsonUtil;
import com.urbanairship.connect.client.model.responses.EventBody;
import java.nio.charset.StandardCharsets;

public class LocationEvent
implements EventBody {
    private final double latitude;
    private final double longitude;
    private final boolean foreground;
    @SerializedName(value="session_id")
    private final Optional<String> sessionId;

    private LocationEvent() {
        this(0.0, 0.0, false, (Optional<String>)Optional.absent());
    }

    public LocationEvent(double latitude, double longitude, boolean foreground, Optional<String> sessionId) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.foreground = foreground;
        this.sessionId = sessionId;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public boolean isForeground() {
        return this.foreground;
    }

    public Optional<String> getSessionId() {
        return this.sessionId;
    }

    public static LocationEvent parseJSONfromBytes(byte[] bytes) {
        JsonObject jsonObject = GsonUtil.parseJSONfromBytes(bytes);
        return LocationEvent.parseJSON(jsonObject.toString());
    }

    public static LocationEvent parseJSON(String json) {
        return (LocationEvent)GsonUtil.getGson().fromJson(json, LocationEvent.class);
    }

    public byte[] serializeToJSONBytes() {
        return GsonUtil.getGson().toJson((Object)this).toString().getBytes(StandardCharsets.UTF_8);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LocationEvent)) {
            return false;
        }
        LocationEvent that = (LocationEvent)o;
        if (this.foreground != that.foreground) {
            return false;
        }
        if (Double.compare(that.latitude, this.latitude) != 0) {
            return false;
        }
        if (Double.compare(that.longitude, this.longitude) != 0) {
            return false;
        }
        return this.sessionId.equals(that.sessionId);
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.latitude);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.longitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.foreground ? 1 : 0);
        result = 31 * result + this.sessionId.hashCode();
        return result;
    }

    public String toString() {
        return "LocationEvent{latitude=" + this.latitude + ", longitude=" + this.longitude + ", foreground=" + this.foreground + ", sessionId=" + this.sessionId + '}';
    }

    @Override
    public EventType getType() {
        return EventType.LOCATION;
    }
}

