/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.connect.client.model.responses;

import com.google.common.base.Optional;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.urbanairship.connect.client.model.EventType;
import com.urbanairship.connect.client.model.GsonUtil;
import com.urbanairship.connect.client.model.responses.AssociatedPush;
import com.urbanairship.connect.client.model.responses.EventBody;

public class OpenEvent
implements EventBody {
    @SerializedName(value="last_delivered")
    private final Optional<AssociatedPush> lastDelivered;
    @SerializedName(value="triggering_push")
    private final Optional<AssociatedPush> triggeringPush;
    @SerializedName(value="session_id")
    private final Optional<String> sessionId;

    private OpenEvent() {
        this((Optional<AssociatedPush>)Optional.absent(), (Optional<AssociatedPush>)Optional.absent(), (Optional<String>)Optional.absent());
    }

    public OpenEvent(Optional<AssociatedPush> lastDelivered, Optional<AssociatedPush> triggeringPush, Optional<String> sessionId) {
        this.lastDelivered = lastDelivered;
        this.triggeringPush = triggeringPush;
        this.sessionId = sessionId;
    }

    public Optional<AssociatedPush> getLastDelivered() {
        return this.lastDelivered;
    }

    public Optional<AssociatedPush> getTriggeringPush() {
        return this.triggeringPush;
    }

    public Optional<String> getSessionId() {
        return this.sessionId;
    }

    public static OpenEvent parseJSONfromBytes(byte[] bytes) {
        JsonObject jsonObject = GsonUtil.parseJSONfromBytes(bytes);
        return OpenEvent.parseJSON(jsonObject.toString());
    }

    public static OpenEvent parseJSON(String json) {
        return (OpenEvent)GsonUtil.getGson().fromJson(json, OpenEvent.class);
    }

    public byte[] serializeToJSONBytes() {
        return GsonUtil.serializeToJSONBytes(this, OpenEvent.class);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpenEvent)) {
            return false;
        }
        OpenEvent openEvent = (OpenEvent)o;
        if (!this.lastDelivered.equals(openEvent.lastDelivered)) {
            return false;
        }
        if (!this.sessionId.equals(openEvent.sessionId)) {
            return false;
        }
        return this.triggeringPush.equals(openEvent.triggeringPush);
    }

    public int hashCode() {
        int result = this.lastDelivered.hashCode();
        result = 31 * result + this.triggeringPush.hashCode();
        result = 31 * result + this.sessionId.hashCode();
        return result;
    }

    public String toString() {
        return "OpenEvent{lastDelivered=" + this.lastDelivered + ", triggeringPush=" + this.triggeringPush + ", sessionId=" + this.sessionId + '}';
    }

    @Override
    public EventType getType() {
        return EventType.OPEN;
    }
}

