/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.connect.client.model.responses;

import com.google.common.base.Optional;
import com.google.gson.JsonObject;
import com.urbanairship.connect.client.model.EventType;
import com.urbanairship.connect.client.model.GsonUtil;
import com.urbanairship.connect.client.model.responses.EventBody;

public class PushBody
implements EventBody {
    private final String pushId;
    private final Optional<String> groupId;
    private final boolean trimmed;
    private final String payload;

    private PushBody() {
        this(null, (Optional<String>)Optional.absent(), false, null);
    }

    public PushBody(String pushId, Optional<String> groupId, boolean trimmed, String payload) {
        this.pushId = pushId;
        this.groupId = groupId;
        this.trimmed = trimmed;
        this.payload = payload;
    }

    public String getPushId() {
        return this.pushId;
    }

    public Optional<String> getGroupId() {
        return this.groupId;
    }

    public boolean isTrimmed() {
        return this.trimmed;
    }

    public String getPayload() {
        return this.payload;
    }

    public static PushBody parseJSONfromBytes(byte[] bytes) {
        JsonObject jsonObject = GsonUtil.parseJSONfromBytes(bytes);
        return PushBody.parseJSON(jsonObject.toString());
    }

    public static PushBody parseJSON(String json) {
        return (PushBody)GsonUtil.getGson().fromJson(json, PushBody.class);
    }

    public byte[] serializeToJSONBytes() {
        return GsonUtil.serializeToJSONBytes(this, PushBody.class);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PushBody pushBody = (PushBody)o;
        if (this.trimmed != pushBody.trimmed) {
            return false;
        }
        if (!this.pushId.equals(pushBody.pushId)) {
            return false;
        }
        if (!this.groupId.equals(pushBody.groupId)) {
            return false;
        }
        return this.payload.equals(pushBody.payload);
    }

    public int hashCode() {
        int result = this.pushId.hashCode();
        result = 31 * result + this.groupId.hashCode();
        result = 31 * result + (this.trimmed ? 1 : 0);
        result = 31 * result + this.payload.hashCode();
        return result;
    }

    public String toString() {
        return "PushBody{pushId='" + this.pushId + '\'' + ", groupId=" + this.groupId + ", trimmed=" + this.trimmed + ", payload='" + this.payload + '\'' + '}';
    }

    @Override
    public EventType getType() {
        return EventType.PUSH_BODY;
    }
}

