/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.connect.client.model.responses;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.urbanairship.connect.client.model.EventType;
import com.urbanairship.connect.client.model.GsonUtil;
import com.urbanairship.connect.client.model.responses.EventBody;
import java.nio.charset.StandardCharsets;

public class ScreenViewedEvent
implements EventBody {
    private final long duration;
    @SerializedName(value="viewed_screen")
    private final String viewedScreen;
    @SerializedName(value="previous_screen")
    private final Optional<String> previousScreen;
    @SerializedName(value="session_id")
    private final String sessionId;

    private ScreenViewedEvent() {
        this(0L, null, (Optional<String>)Optional.absent(), null);
    }

    public ScreenViewedEvent(long duration, String viewedScreen, Optional<String> previousScreen, String sessionId) {
        this.duration = duration;
        this.viewedScreen = viewedScreen;
        this.previousScreen = previousScreen;
        this.sessionId = sessionId;
    }

    @Override
    public EventType getType() {
        return EventType.SCREEN_VIEWED;
    }

    public long getDuration() {
        return this.duration;
    }

    public String getViewedScreen() {
        return this.viewedScreen;
    }

    public Optional<String> getPreviousScreen() {
        return this.previousScreen;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public static ScreenViewedEvent parseJSONfromBytes(byte[] bytes) {
        JsonObject jsonObject = GsonUtil.parseJSONfromBytes(bytes);
        return ScreenViewedEvent.parseJSON(jsonObject.toString());
    }

    public static ScreenViewedEvent parseJSON(String json) {
        return (ScreenViewedEvent)GsonUtil.getGson().fromJson(json, ScreenViewedEvent.class);
    }

    public byte[] serializeToJSONBytes() {
        return GsonUtil.getGson().toJson((Object)this).getBytes(StandardCharsets.UTF_8);
    }

    public String toString() {
        return "ScreenViewedEvent{duration=" + this.duration + ", viewedScreen='" + this.viewedScreen + '\'' + ", previousScreen=" + this.previousScreen + ", sessionId='" + this.sessionId + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScreenViewedEvent that = (ScreenViewedEvent)o;
        if (this.getDuration() != that.getDuration()) {
            return false;
        }
        if (this.getViewedScreen() != null ? !this.getViewedScreen().equals(that.getViewedScreen()) : that.getViewedScreen() != null) {
            return false;
        }
        if (this.getPreviousScreen() != null ? !this.getPreviousScreen().equals(that.getPreviousScreen()) : that.getPreviousScreen() != null) {
            return false;
        }
        return this.getSessionId() != null ? this.getSessionId().equals(that.getSessionId()) : that.getSessionId() == null;
    }

    public int hashCode() {
        int result = (int)(this.getDuration() ^ this.getDuration() >>> 32);
        result = 31 * result + (this.getViewedScreen() != null ? this.getViewedScreen().hashCode() : 0);
        result = 31 * result + (this.getPreviousScreen() != null ? this.getPreviousScreen().hashCode() : 0);
        result = 31 * result + (this.getSessionId() != null ? this.getSessionId().hashCode() : 0);
        return result;
    }

    public static class Builder {
        private long duration;
        private String viewedScreen;
        private Optional<String> previousScreen = Optional.absent();
        private String sessionId;

        public Builder setDuration(long duration) {
            this.duration = duration;
            return this;
        }

        public Builder setViewedScreen(String viewedScreen) {
            this.viewedScreen = viewedScreen;
            return this;
        }

        public Builder setPreviousScreen(String previousScreen) {
            this.previousScreen = Optional.of((Object)previousScreen);
            return this;
        }

        public Builder setSessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public ScreenViewedEvent build() {
            Preconditions.checkNotNull((Object)this.duration);
            Preconditions.checkNotNull((Object)this.viewedScreen);
            Preconditions.checkNotNull((Object)this.sessionId);
            return new ScreenViewedEvent(this.duration, this.viewedScreen, this.previousScreen, this.sessionId);
        }
    }
}

