/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.connect.client.model.responses;

import com.google.common.base.Optional;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.urbanairship.connect.client.model.EventType;
import com.urbanairship.connect.client.model.GsonUtil;
import com.urbanairship.connect.client.model.responses.EventBody;

public class SendEvent
implements EventBody {
    @SerializedName(value="push_id")
    private final String pushId;
    @SerializedName(value="group_id")
    private final Optional<String> groupId;
    @SerializedName(value="variant_id")
    private final Optional<Integer> variantId;

    private SendEvent() {
        this(null, (Optional<String>)Optional.absent(), (Optional<Integer>)Optional.absent());
    }

    public SendEvent(String pushId, Optional<String> groupId, Optional<Integer> variantId) {
        this.pushId = pushId;
        this.groupId = groupId;
        this.variantId = variantId;
    }

    public Optional<Integer> getVariantId() {
        return this.variantId;
    }

    public Optional<String> getGroupId() {
        return this.groupId;
    }

    public String getPushId() {
        return this.pushId;
    }

    public static SendEvent parseJSONfromBytes(byte[] bytes) {
        JsonObject jsonObject = GsonUtil.parseJSONfromBytes(bytes);
        return SendEvent.parseJSON(jsonObject.toString());
    }

    public static SendEvent parseJSON(String json) {
        return (SendEvent)GsonUtil.getGson().fromJson(json, SendEvent.class);
    }

    public byte[] serializeToJSONBytes() {
        return GsonUtil.serializeToJSONBytes(this, SendEvent.class);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SendEvent)) {
            return false;
        }
        SendEvent sendEvent = (SendEvent)o;
        if (!this.groupId.equals(sendEvent.groupId)) {
            return false;
        }
        if (!this.pushId.equals(sendEvent.pushId)) {
            return false;
        }
        return this.variantId.equals(sendEvent.variantId);
    }

    public int hashCode() {
        int result = this.pushId.hashCode();
        result = 31 * result + this.groupId.hashCode();
        result = 31 * result + this.variantId.hashCode();
        return result;
    }

    public String toString() {
        return "SendEvent{pushId='" + this.pushId + '\'' + ", groupId=" + this.groupId + ", variantId=" + this.variantId + '}';
    }

    @Override
    public EventType getType() {
        return EventType.SEND;
    }
}

