/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.connect.client.model.responses;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.urbanairship.connect.client.model.EventType;
import com.urbanairship.connect.client.model.responses.EventBody;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;

public class TagChange
implements EventBody {
    private static final JsonParser parser = new JsonParser();
    private static final Gson gson = new Gson();
    @SerializedName(value="add")
    private final Map<String, Collection<String>> tagAdd;
    @SerializedName(value="remove")
    private final Map<String, Collection<String>> tagRemove;
    @SerializedName(value="current")
    private final Map<String, Collection<String>> tagCurrent;

    private TagChange() {
        this(null, null, null);
    }

    private TagChange(Map<String, Collection<String>> tagAdd, Map<String, Collection<String>> tagRemove, Map<String, Collection<String>> tagCurrent) {
        this.tagAdd = tagAdd;
        this.tagRemove = tagRemove;
        this.tagCurrent = tagCurrent;
    }

    public Map<String, Collection<String>> getTagAdd() {
        return this.tagAdd;
    }

    public Map<String, Collection<String>> getTagRemove() {
        return this.tagRemove;
    }

    public Map<String, Collection<String>> getTagCurrent() {
        return this.tagCurrent;
    }

    public static TagChange parseJSONfromBytes(byte[] bytes) {
        String byteString = new String(bytes, StandardCharsets.UTF_8);
        JsonObject jsonObject = parser.parse(byteString).getAsJsonObject();
        return TagChange.parseJSON(jsonObject.toString());
    }

    public static TagChange parseJSON(String json) {
        return (TagChange)gson.fromJson(json, TagChange.class);
    }

    public static TagChange parseJSON(JsonElement json) {
        return (TagChange)gson.fromJson(json, TagChange.class);
    }

    public byte[] serializeToJSONBytes() {
        return gson.toJson((Object)this).toString().getBytes(StandardCharsets.UTF_8);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TagChange tagChange = (TagChange)o;
        if (this.tagAdd != null ? !this.tagAdd.equals(tagChange.tagAdd) : tagChange.tagAdd != null) {
            return false;
        }
        if (this.tagRemove != null ? !this.tagRemove.equals(tagChange.tagRemove) : tagChange.tagRemove != null) {
            return false;
        }
        return !(this.tagCurrent == null ? tagChange.tagCurrent != null : !this.tagCurrent.equals(tagChange.tagCurrent));
    }

    public int hashCode() {
        int result = this.tagAdd != null ? this.tagAdd.hashCode() : 0;
        result = 31 * result + (this.tagRemove != null ? this.tagRemove.hashCode() : 0);
        result = 31 * result + (this.tagCurrent != null ? this.tagCurrent.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "TagChange{tagAdd=" + this.tagAdd + ", tagRemove=" + this.tagRemove + ", tagCurrent=" + this.tagCurrent + '}';
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public EventType getType() {
        return EventType.TAG_CHANGE;
    }

    public static class Builder {
        private Map<String, Collection<String>> tagAdd = null;
        private Map<String, Collection<String>> tagRemove = null;
        private Map<String, Collection<String>> tagCurrent = null;

        public Builder setTagAdd(Map<String, Collection<String>> tagAdd) {
            this.tagAdd = tagAdd;
            return this;
        }

        public Builder setTagRemove(Map<String, Collection<String>> tagRemove) {
            this.tagRemove = tagRemove;
            return this;
        }

        public Builder setTagCurrent(Map<String, Collection<String>> tagCurrent) {
            this.tagCurrent = tagCurrent;
            return this;
        }

        public TagChange build() {
            return new TagChange(this.tagAdd, this.tagRemove, this.tagCurrent);
        }
    }
}

