/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.connect.client.model.responses.region;

import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;

public class CircularRegion {
    @SerializedName(value="lat")
    private final double latitude;
    @SerializedName(value="long")
    private final double longitude;
    private final int radius;

    private CircularRegion() {
        this(0.0, 0.0, 0);
    }

    private CircularRegion(double latitude, double longitude, int radius) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.radius = radius;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public int getRadius() {
        return this.radius;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CircularRegion)) {
            return false;
        }
        CircularRegion that = (CircularRegion)o;
        if (Double.compare(that.latitude, this.latitude) != 0) {
            return false;
        }
        if (Double.compare(that.longitude, this.longitude) != 0) {
            return false;
        }
        return this.radius == that.radius;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.latitude);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.longitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.radius;
        return result;
    }

    public String toString() {
        return "CircularRegion{latitude=" + this.latitude + ", longitude=" + this.longitude + ", radius=" + this.radius + '}';
    }

    public static class Builder {
        @SerializedName(value="lat")
        private double latitude;
        @SerializedName(value="long")
        private double longitude;
        private int radius;

        private Builder() {
        }

        public Builder setLatitude(double value) {
            this.latitude = value;
            return this;
        }

        public Builder setLongitude(double value) {
            this.longitude = value;
            return this;
        }

        public Builder setRadius(int value) {
            this.radius = value;
            return this;
        }

        public CircularRegion build() {
            Preconditions.checkNotNull((Object)this.latitude, (Object)"latitude must be set");
            Preconditions.checkNotNull((Object)this.longitude, (Object)"longitude must be set");
            Preconditions.checkNotNull((Object)this.radius, (Object)"radius must be set");
            return new CircularRegion(this.latitude, this.longitude, this.radius);
        }
    }
}

