/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.connect.client.model.responses.region;

import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;

public class Proximity {
    @SerializedName(value="beacon_id")
    private final String beaconId;
    private final int major;
    private final int minor;
    private final int rssi;
    @SerializedName(value="lat")
    private final double latitude;
    @SerializedName(value="long")
    private final double longitude;

    private Proximity() {
        this(null, 0, 0, 0, 0.0, 0.0);
    }

    private Proximity(String beaconId, int major, int minor, int rssi, double latitude, double longitude) {
        this.beaconId = beaconId;
        this.major = major;
        this.minor = minor;
        this.rssi = rssi;
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getBeaconId() {
        return this.beaconId;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getRssi() {
        return this.rssi;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Proximity)) {
            return false;
        }
        Proximity proximity = (Proximity)o;
        if (Double.compare(proximity.latitude, this.latitude) != 0) {
            return false;
        }
        if (Double.compare(proximity.longitude, this.longitude) != 0) {
            return false;
        }
        if (this.major != proximity.major) {
            return false;
        }
        if (this.minor != proximity.minor) {
            return false;
        }
        if (this.rssi != proximity.rssi) {
            return false;
        }
        return this.beaconId.equals(proximity.beaconId);
    }

    public int hashCode() {
        int result = this.beaconId.hashCode();
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.rssi;
        long temp = Double.doubleToLongBits(this.latitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.longitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "Proximity{beaconId='" + this.beaconId + '\'' + ", major=" + this.major + ", minor=" + this.minor + ", rssi=" + this.rssi + ", latitude='" + this.latitude + '\'' + ", longitude='" + this.longitude + '\'' + '}';
    }

    public static class Builder {
        @SerializedName(value="beacon_id")
        private String beaconId;
        private int major;
        private int minor;
        private int rssi;
        @SerializedName(value="lat")
        private double latitude;
        @SerializedName(value="long")
        private double longitude;

        private Builder() {
        }

        public Builder setBeaconId(String value) {
            this.beaconId = value;
            return this;
        }

        public Builder setMajor(int value) {
            this.major = value;
            return this;
        }

        public Builder setMinor(int value) {
            this.minor = value;
            return this;
        }

        public Builder setRssi(int value) {
            this.rssi = value;
            return this;
        }

        public Builder setLatitude(double value) {
            this.latitude = value;
            return this;
        }

        public Builder setLongitude(double value) {
            this.longitude = value;
            return this;
        }

        public Proximity build() {
            Preconditions.checkNotNull((Object)this.beaconId, (Object)"beacon ID must be set");
            Preconditions.checkNotNull((Object)this.major, (Object)"major must be set");
            Preconditions.checkNotNull((Object)this.minor, (Object)"minor must be set");
            Preconditions.checkNotNull((Object)this.rssi, (Object)"rssi must be set");
            Preconditions.checkNotNull((Object)this.latitude, (Object)"latitude must be set");
            Preconditions.checkNotNull((Object)this.longitude, (Object)"longitude must be set");
            return new Proximity(this.beaconId, this.major, this.minor, this.rssi, this.latitude, this.longitude);
        }
    }
}

