/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.connect.client.model.responses.region;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.urbanairship.connect.client.model.EventType;
import com.urbanairship.connect.client.model.GsonUtil;
import com.urbanairship.connect.client.model.responses.EventBody;
import com.urbanairship.connect.client.model.responses.region.CircularRegion;
import com.urbanairship.connect.client.model.responses.region.Proximity;
import com.urbanairship.connect.client.model.responses.region.RegionAction;
import com.urbanairship.connect.client.model.responses.region.RegionSource;
import java.nio.charset.StandardCharsets;

public class RegionEvent
implements EventBody {
    private static final JsonParser parser = new JsonParser();
    private static final Gson gson = GsonUtil.getGson();
    private final RegionAction action;
    @SerializedName(value="region_id")
    private final String regionId;
    private final RegionSource source;
    @SerializedName(value="session_id")
    private final String sessionId;
    private final Optional<Proximity> proximity;
    @SerializedName(value="circular_region")
    private final Optional<CircularRegion> circularRegion;

    private RegionEvent() {
        this(null, null, null, null, (Optional<Proximity>)Optional.absent(), (Optional<CircularRegion>)Optional.absent());
    }

    private RegionEvent(RegionAction action, String regionId, RegionSource source, String sessionId, Optional<Proximity> proximity, Optional<CircularRegion> circularRegion) {
        this.action = action;
        this.regionId = regionId;
        this.source = source;
        this.sessionId = sessionId;
        this.proximity = proximity;
        this.circularRegion = circularRegion;
    }

    public RegionAction getAction() {
        return this.action;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public RegionSource getSource() {
        return this.source;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Optional<Proximity> getProximity() {
        return this.proximity;
    }

    public Optional<CircularRegion> getCircularRegion() {
        return this.circularRegion;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public EventType getType() {
        return EventType.REGION;
    }

    public static RegionEvent parseJSONfromBytes(byte[] bytes) {
        String byteString = new String(bytes, StandardCharsets.UTF_8);
        JsonObject jsonObject = parser.parse(byteString).getAsJsonObject();
        return RegionEvent.parseJSON(jsonObject.toString());
    }

    public static RegionEvent parseJSON(String json) {
        return (RegionEvent)gson.fromJson(json, RegionEvent.class);
    }

    public static RegionEvent parseJSON(JsonElement json) {
        return (RegionEvent)gson.fromJson(json, RegionEvent.class);
    }

    public byte[] serializeToJSONBytes() {
        return gson.toJson((Object)this).toString().getBytes(StandardCharsets.UTF_8);
    }

    public static class Builder {
        private RegionAction action;
        @SerializedName(value="region_id")
        private String regionId;
        private RegionSource source;
        @SerializedName(value="session_id")
        private String sessionId;
        private Proximity proximity = null;
        @SerializedName(value="circular_region")
        private CircularRegion circularRegion = null;

        private Builder() {
        }

        public Builder setAction(RegionAction value) {
            this.action = value;
            return this;
        }

        public Builder setRegionId(String value) {
            this.regionId = value;
            return this;
        }

        public Builder setSource(RegionSource value) {
            this.source = value;
            return this;
        }

        public Builder setSessionId(String value) {
            this.sessionId = value;
            return this;
        }

        public Builder setProximity(Proximity value) {
            this.proximity = value;
            return this;
        }

        public Builder setCircularRegion(CircularRegion value) {
            this.circularRegion = value;
            return this;
        }

        public RegionEvent build() {
            Preconditions.checkNotNull((Object)((Object)this.action), (Object)"action must be set");
            Preconditions.checkNotNull((Object)this.regionId, (Object)"regionId must be set");
            Preconditions.checkNotNull((Object)((Object)this.source), (Object)"source must be set");
            Preconditions.checkNotNull((Object)this.sessionId, (Object)"sessionId must be set");
            return new RegionEvent(this.action, this.regionId, this.source, this.sessionId, Optional.fromNullable((Object)this.proximity), Optional.fromNullable((Object)this.circularRegion));
        }
    }
}

