/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.connect.client.offsets;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.io.Files;
import com.urbanairship.connect.client.offsets.OffsetManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class InFileOffsetManager
implements OffsetManager {
    private static final Logger logger = LogManager.getLogger(InFileOffsetManager.class);
    private final File offsetFile;
    private final AtomicReference<String> offset = new AtomicReference<Object>(null);

    public InFileOffsetManager(String appKey) {
        this.offsetFile = new File(System.getProperty("user.dir"), "." + appKey + "-offsets");
        Optional<String> loadedOffset = this.loadOffset();
        if (loadedOffset.isPresent()) {
            this.offset.set((String)loadedOffset.get());
        }
    }

    @Override
    public Optional<String> getLastOffset() {
        return Optional.fromNullable((Object)this.offset.get());
    }

    @Override
    public void update(String offset) {
        this.offset.set(offset);
        try {
            this.saveOffset();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to update offset in file: " + this.offsetFile.getName(), e);
        }
    }

    private synchronized Optional<String> loadOffset() {
        if (!this.offsetFile.exists()) {
            logger.debug((Object)("No apps file exists: " + this.offsetFile.getAbsolutePath()));
            return Optional.absent();
        }
        try {
            this.offset.set(Files.toString((File)this.offsetFile, (Charset)Charsets.UTF_8));
        }
        catch (IOException e) {
            logger.warn((Object)("Failed to read file: " + this.offsetFile.getName()), (Throwable)e);
        }
        return Optional.fromNullable((Object)this.offset.get());
    }

    private synchronized void saveOffset() throws IOException {
        BufferedWriter writer = Files.newWriter((File)this.offsetFile, (Charset)Charsets.UTF_8);
        writer.write(this.offset.get());
        ((Writer)writer).flush();
        ((Writer)writer).close();
    }
}

