package com.vaadin.spring.roo.addon.abstractentityview;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.osgi.service.component.ComponentContext;
import org.springframework.roo.classpath.PhysicalTypeIdentifier;
import org.springframework.roo.classpath.PhysicalTypeMetadata;
import org.springframework.roo.classpath.TypeLocationService;
import org.springframework.roo.classpath.itd.AbstractItdMetadataProvider;
import org.springframework.roo.classpath.itd.ItdTypeDetailsProvidingMetadataItem;
import org.springframework.roo.model.JavaType;
import org.springframework.roo.project.Path;
import org.springframework.roo.project.ProjectOperations;

import com.vaadin.spring.roo.addon.annotations.RooVaadinAbstractEntityView;

/**
 * Simple metadata provider for {@link RooVaadinAbstractEntityView}, which is
 * used primarily for finding classes with that annotation.
 */
@Component(immediate = true)
@Service
public class VaadinAbstractEntityViewMetadataProvider extends
		AbstractItdMetadataProvider {

	@Reference
	private ProjectOperations projectOperations;
	@Reference
	private TypeLocationService typeLocationService;

	protected void activate(ComponentContext context) {
		metadataDependencyRegistry.registerDependency(
				PhysicalTypeIdentifier.getMetadataIdentiferType(),
				getProvidesType());
		addMetadataTrigger(VaadinAbstractEntityViewMetadata.getAnnotationType());
	}

	@Override
	protected ItdTypeDetailsProvidingMetadataItem getMetadata(
			String metadataIdentificationString, JavaType aspectName,
			PhysicalTypeMetadata governorPhysicalTypeMetadata,
			String itdFilename) {
		// check annotation first
		VaadinAbstractEntityViewAnnotationValues annotationValues = new VaadinAbstractEntityViewAnnotationValues(
				governorPhysicalTypeMetadata);
		if (!annotationValues.isAnnotationFound()) {
			return null;
		}

		return new VaadinAbstractEntityViewMetadata(
				metadataIdentificationString, aspectName,
				governorPhysicalTypeMetadata, projectOperations,
				fileManager, typeLocationService, annotationValues);
	}

	public String getItdUniquenessFilenameSuffix() {
		return "AbstractEntityView";
	}

	@Override
	protected String getGovernorPhysicalTypeIdentifier(
			String metadataIdentificationString) {
		JavaType javaType = VaadinAbstractEntityViewMetadata
				.getJavaType(metadataIdentificationString);
		Path path = VaadinAbstractEntityViewMetadata
				.getPath(metadataIdentificationString);
		String physicalTypeIdentifier = PhysicalTypeIdentifier
				.createIdentifier(javaType, path);
		return physicalTypeIdentifier;
	}

	@Override
	protected String createLocalIdentifier(JavaType javaType, Path path) {
		return VaadinAbstractEntityViewMetadata
				.createIdentifier(javaType, path);
	}

	public String getProvidesType() {
		return VaadinAbstractEntityViewMetadata.getMetadataIdentiferType();
	}

}
