package com.vaadin.spring.roo.addon.addons;

import org.springframework.roo.support.style.ToStringCreator;
import org.springframework.roo.support.util.Assert;

public class VaadinAddonArtifactId implements Comparable<VaadinAddonArtifactId> {

	// artifact id
	private String key;

	public VaadinAddonArtifactId(String key) {
		Assert.hasText(key, "bundle symbolic name required");
		this.key = key;
	}

	@Override
	public final int hashCode() {
		return key.hashCode();
	}

	@Override
	public final boolean equals(Object obj) {
		return obj instanceof VaadinAddonArtifactId
				&& compareTo((VaadinAddonArtifactId) obj) == 0;
	}

	public final int compareTo(VaadinAddonArtifactId o) {
		if (o == null) {
			return -1;
		}
		return key.compareTo(o.key);
	}

	public String getKey() {
		return key;
	}

	@Override
	public String toString() {
		ToStringCreator tsc = new ToStringCreator(this);
		tsc.append("key", key);
		return tsc.toString();
	}

}
