package com.vaadin.spring.roo.addon.addons;

import java.util.List;
import java.util.Map;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.springframework.roo.shell.Converter;
import org.springframework.roo.shell.MethodTarget;

/**
 * Converter from string to {@link VaadinAddonArtifactId}. This is also used for
 * tab completion.
 */
@Component
@Service
public class VaadinAddonArtifactIdConverter implements Converter {

	private @Reference
	VaadinAddonOperations addonOperations;

	public Object convertFromText(String value, Class<?> requiredType,
			String optionContext) {
		return new VaadinAddonArtifactId(value.trim());
	}

	public boolean getAllPossibleValues(List<String> completions,
			Class<?> requiredType, String originalUserInput,
			String optionContext, MethodTarget target) {
		Map<String, String> addons = addonOperations.getAddOnCache(false);
		for (String artifactId : addons.keySet()) {
			if (artifactId.startsWith(originalUserInput)) {
				completions.add(artifactId);
			}
		}
		return false;
	}

	public boolean supports(Class<?> requiredType, String optionContext) {
		return VaadinAddonArtifactId.class.isAssignableFrom(requiredType);
	}

}
