package com.vaadin.spring.roo.addon.addons;

import java.util.Map;

/**
 * Operations related to the use of Vaadin add-ons, including add-on
 * installation and command completion for add-on group ip, artifact id or
 * version.
 */
public interface VaadinAddonOperations {

	/**
	 * Install an add-on in the project (add a dependency to the add-on).
	 * 
	 * This command does not create or update widgetsets - use explicit commands
	 * for that.
	 * 
	 * @param groupId
	 *            Maven group id for the artifact or null to try to find
	 *            automatically
	 * @param artifactId
	 *            Maven artifact id for the artifact (not null)
	 * @param version
	 *            Maven version number for the artifact or "LATEST" or null
	 *            (latest numerical version from metadata if information
	 *            available, otherwise "LATEST")
	 */
	public void installAddon(String groupId, VaadinAddonArtifactId artifactId,
			String version);

	/**
	 * Returns (a read-only reference to) the Vaadin add-on cache.
	 *
	 * @param refresh
	 *            reload add-on cache
	 * @return Map from artifact id to additional information about the add-on
	 */
	public Map<String, String> getAddOnCache(boolean refresh);

}
