package com.vaadin.spring.roo.addon.addons;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.osgi.service.component.ComponentContext;
import org.springframework.roo.project.Dependency;
import org.springframework.roo.project.ProjectOperations;
import org.springframework.roo.support.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Component
@Service
public class VaadinAddonOperationsImpl implements VaadinAddonOperations {

	private static final String METADATA_URL = "http://vaadin.com/download/internal/maven-addons/maven-metadata.xml";

	private static Logger logger = Logger.getLogger(VaadinAddonOperations.class
			.getName());

	@Reference
	private ProjectOperations projectOperations;

	// Map from artifact id to group id
	// TODO use a class for a Vaadin add-on, not just groupId
	private Map<String, String> addonCache;
	// Map from artifact id to latest version number
	private Map<String, String> latestVersionCache;

	// TODO this causes problems at runtime - bundle dependency problem?
	// @Reference
	// private UrlInputStreamService urlInputStreamService;

	private static final Logger log = Logger
			.getLogger(VaadinAddonOperationsImpl.class.getName());

	protected void activate(ComponentContext context) {
		addonCache = new HashMap<String, String>();
		latestVersionCache = new HashMap<String, String>();

		Thread t = new Thread(new Runnable() {
			public void run() {
				populateVaadinAddonCache(true);
			}
		}, "Vaadin Add-on Index XML Eager Download");
		t.start();
	}

	// based on org.springframework.roo.addon.roobot.client
	private boolean populateVaadinAddonCache(boolean startupTime) {
		boolean success = false;
		InputStream is = null;
		try {
			DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			DocumentBuilder db = dbf.newDocumentBuilder();
			String url = METADATA_URL;
			// if (url.startsWith("http://")) {
			// // Handle it as HTTP
			// URL httpUrl = new URL(url);
			// String failureMessage = urlInputStreamService
			// .getUrlCannotBeOpenedMessage(httpUrl);
			// if (failureMessage != null) {
			// if (!startupTime) {
			// // This wasn't just an eager startup time attempt, so
			// // let's display the error reason
			// // (for startup time, we just fail quietly)
			// log.warning(failureMessage);
			// }
			// return false;
			// }
			// // It appears we can acquire the URL, so let's do it
			// is = urlInputStreamService.openConnection(httpUrl);
			// } else {
				// Fallback to normal protocol handler (likely in local
				// development testing etc
				is = new URL(url).openStream();
			// }
			if (is == null) {
				log.warning("Could not connect to Roo Addon bundle repository index");
				return false;
			}

			Document addonsXml = db.parse(new BufferedInputStream(is));

			if (addonsXml != null) {
				addonCache.clear();
				for (Element addonElement : XmlUtils.findElements(
						"/maven-metadata/metadata",
						addonsXml.getDocumentElement())) {

					Element groupIdElement = XmlUtils.findFirstElementByName(
							"groupId", addonElement);
					if (groupIdElement == null) {
						continue;
					}
					String groupId = groupIdElement.getTextContent().trim();

					Element artifactIdElement = XmlUtils
							.findFirstElementByName("artifactId", addonElement);
					if (artifactIdElement == null) {
						continue;
					}
					String artifactId = artifactIdElement.getTextContent()
							.trim();

					Element latestElement = XmlUtils.findFirstElement(
							"versioning/latest", addonElement);
					if (latestElement != null) {
						latestVersionCache.put(artifactId, latestElement
								.getTextContent().trim());
					}

					// TODO keep a cache of other versions?

					// List<String> versions = new LinkedList<String>();
					// for (Element versionElement : XmlUtils.findElements(
					// "versioning/versions/version", addonElement)) {
					// String value = versionElement.getTextContent();
					// if (value != null) {
					// value = value.trim();
					// if (!"".equals(value)) {
					// versions.add(value);
					// }
					// }
					// }

					addonCache.put(artifactId, groupId);
				}
				success = true;
			}
		} catch (Throwable ignore) {
		} finally {
			try {
				if (is != null) {
					is.close();
				}
			} catch (IOException ignored) {
			}
		}
		return success;
	}

	public Map<String, String> getAddOnCache(boolean refresh) {
		if (refresh) {
			populateVaadinAddonCache(false);
		}
		return Collections.unmodifiableMap(addonCache);
	}

	public void installAddon(String groupId, VaadinAddonArtifactId artifactId,
			String version) {
		if (version == null) {
			version = latestVersionCache.get(artifactId.getKey());
			if (version == null) {
				version = "LATEST";
			}
		}
		if (groupId == null) {
			groupId = addonCache.get(artifactId.getKey());
			if (groupId == null) {
				log.warning("Could not find groupId for the Vaadin add-on with artifactId: "
						+ artifactId.getKey());
				log.warning("Please specify groupId with --groupId");
				return;
			}
		}
		Dependency dependency = new Dependency(groupId, artifactId.getKey(),
				version);
		projectOperations.addDependency(dependency);

		logger.info("[HINT] If the add-on has client side widgets, create or update the project widgetset:");
		logger.info("[HINT]  'vaadin widgetset create' or 'vaadin widgetset update'");
	}

}
