package com.vaadin.spring.roo.addon.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Indicates a type that acts as a base class for classes with the
 * {@link RooVaadinEntityView} annotation.
 * 
 * <p>
 * Most of the UI structure and logic for entity CRUD views is in this base
 * class.
 * 
 * <p>
 * This annotation is currently only used when searching for potential entity
 * view base classes if none is specified when creating entity views.
 * 
 * <p>
 * This annotation is dual licensed under both GNU General Public License,
 * Version 3 and also Apache License, Version 2.0. You may apply your choice of
 * GPLv3 or ASLv2 to your use of the this annotation.
 */
@Retention(RetentionPolicy.SOURCE)
@Target(ElementType.TYPE)
public @interface RooVaadinAbstractEntityView {

	/**
	 * Use the JPAContainer where applicable instead of a statically populated
	 * container for entities.
	 * 
	 * @return indicates if the JPAContainer should be used in the editor view
	 *         (defaults to "false"; optional)
	 */
	boolean useJpaContainer() default false;

}
